/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.uihandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.css.ECSSUnit;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.sections.HCH1;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.interror.uihandler.IUIInternalErrorHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UIInternalErrorHandler
implements IUIInternalErrorHandler {
    private final IHCNodeWithChildren<?> m_aParentNode;

    public UIInternalErrorHandler(@Nonnull IHCNodeWithChildren<?> iHCNodeWithChildren) {
        this.m_aParentNode = ValueEnforcer.notNull(iHCNodeWithChildren, "ParentNode");
    }

    @Nonnull
    public IHCNodeWithChildren<?> getParentNode() {
        return this.m_aParentNode;
    }

    @Override
    public void onInternalError(@Nullable Throwable throwable, @Nonnull String string, @Nonnull Locale locale) {
        this.m_aParentNode.addChild(new HCH1().addChild(EPhotonCoreText.INTERNAL_ERROR_TITLE.getDisplayText(locale)));
        this.m_aParentNode.addChild(new HCDiv().addChildren(HCExtHelper.nl2brList(EPhotonCoreText.INTERNAL_ERROR_DESCRIPTION.getDisplayTextWithArgs(locale, string))));
        if (GlobalDebug.isDebugMode() && throwable != null) {
            String string2 = StackTraceHelper.getStackAsString(throwable, false);
            HCTextArea hCTextArea = (HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)new HCTextArea("callstack").setValue(string2)).setRows(20)).addStyle(CCSSProperties.WIDTH.newValue(ECSSUnit.perc(98)))).addStyle(CCSSProperties.FONT_SIZE.newValue(ECSSUnit.pt(10)))).addStyle(CCSSProperties.FONT_FAMILY.newValue("Courier New"));
            this.m_aParentNode.addChild(hCTextArea);
        }
    }
}

