/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.app;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.misc.SizeHelper;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class CheckDiskUsableSpaceJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckDiskUsableSpaceJob.class);
    private static final String JOB_DATA_ATTR_THRESHOLD_BYTES = "threshold-bytes";
    private static final String JOB_DATA_ATTR_PATH_SUPPLIER = "path-supplier";
    private static final AtomicInteger JOB_COUNT = new AtomicInteger(0);

    @Override
    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        long l;
        long l2 = jobDataMap.getAsLong(JOB_DATA_ATTR_THRESHOLD_BYTES);
        ISupplier iSupplier = (ISupplier)jobDataMap.getCastedValue(JOB_DATA_ATTR_PATH_SUPPLIER);
        File file = (File)iSupplier.get();
        String string = file.getAbsolutePath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking for usable space on '" + string + "' with a threshold of " + l2 + " bytes");
        }
        if ((l = file.getUsableSpace()) <= l2) {
            SizeHelper sizeHelper = SizeHelper.getSizeHelperOfLocale(CGlobal.LOCALE_FIXED_NUMBER_FORMAT);
            String string2 = sizeHelper.getAsMatching(l2, 3);
            String string3 = sizeHelper.getAsMatching(l, 3);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("File system of '" + string + "' has less or equal than " + string2 + " of usable space: " + string3);
            }
            String string4 = InternalErrorHandler.fillInternalErrorMetaData(null, "out-of-usable-disk-space", null).addField("base path", string).addField("threshold space", string2).addField("usable space", string3).getAsString();
            EmailData emailData = new EmailData(EEmailType.TEXT);
            emailData.setFrom(InternalErrorSettings.getSMTPSenderAddress());
            emailData.to().addAll(InternalErrorSettings.getSMTPReceiverAddresses());
            emailData.setSubject("[ph-oton] Usable Disk Space on '" + string + "' is low: " + string3);
            emailData.setBody(string4);
            ScopedMailAPI.getInstance().queueMail(InternalErrorSettings.getSMTPSettings(), emailData);
        }
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull IScheduleBuilder<? extends ITrigger> iScheduleBuilder, @Nonnegative long l) {
        return CheckDiskUsableSpaceJob.schedule(iScheduleBuilder, l, () -> WebFileIO.getDataIO().getBasePathFile());
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull IScheduleBuilder<? extends ITrigger> iScheduleBuilder, @Nonnegative long l, @Nonnull ISupplier<File> iSupplier) {
        ValueEnforcer.notNull(iScheduleBuilder, "ScheduleBuilder");
        ValueEnforcer.isGE0(l, "ThresholdBytes");
        ValueEnforcer.notNull(iSupplier, "PathSupplier");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        commonsHashMap.put(JOB_DATA_ATTR_THRESHOLD_BYTES, l);
        commonsHashMap.put(JOB_DATA_ATTR_PATH_SUPPLIER, iSupplier);
        return GlobalQuartzScheduler.getInstance().scheduleJob(CheckDiskUsableSpaceJob.class.getName() + JOB_COUNT.incrementAndGet(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule(iScheduleBuilder), CheckDiskUsableSpaceJob.class, commonsHashMap);
    }
}

