/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.app;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.deadlock.ThreadDeadlockDetector;
import com.helger.photon.core.interror.callback.MailingThreadDeadlockCallback;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class CheckThreadDeadlockJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckThreadDeadlockJob.class);

    @Override
    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking for dead locks");
        }
        ThreadDeadlockDetector threadDeadlockDetector = new ThreadDeadlockDetector();
        threadDeadlockDetector.callbacks().add(new MailingThreadDeadlockCallback());
        threadDeadlockDetector.findDeadlockedThreads();
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull SimpleScheduleBuilder simpleScheduleBuilder) {
        ValueEnforcer.notNull(simpleScheduleBuilder, "ScheduleBuilder");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        return GlobalQuartzScheduler.getInstance().scheduleJob(CheckThreadDeadlockJob.class.getName(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule(simpleScheduleBuilder), CheckThreadDeadlockJob.class, commonsHashMap);
    }
}

