/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.longrun;

import com.helger.commons.state.ESuccess;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.photon.core.longrun.LongRunningJobManager;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.schedule.job.AbstractJob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongRunningJob
extends AbstractJob
implements ILongRunningJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLongRunningJob.class);
    private static final String KEY_LONG_RUNNING_JOB_ID = "$ph-longrunning.job.id";

    @Nullable
    protected abstract String getCurrentUserID(@Nonnull JobDataMap var1);

    @Nonnull
    protected final LongRunningJobManager getLongRunningJobManager() {
        return PhotonBasicManager.getLongRunningJobMgr();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
        String string = this.getCurrentUserID(jobDataMap);
        String string2 = this.getLongRunningJobManager().onStartJob(this, string);
        jobDataMap.put(KEY_LONG_RUNNING_JOB_ID, string2);
        super.beforeExecute(jobDataMap, iJobExecutionContext);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
        try {
            String string = jobDataMap.getAsString(KEY_LONG_RUNNING_JOB_ID);
            if (string != null) {
                LongRunningJobResult longRunningJobResult = this.createLongRunningJobResult();
                this.getLongRunningJobManager().onEndJob(string, eSuccess, longRunningJobResult);
            } else {
                LOGGER.error("Failed to retrieve long running job ID from JobDataMap " + jobDataMap);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to end long running job", throwable);
            AbstractLongRunningJob.triggerCustomExceptionHandler(throwable, this.getClass().getName(), this);
        }
        super.afterExecute(jobDataMap, iJobExecutionContext, eSuccess);
    }
}

