/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.smtp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class FailedMailResendJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedMailResendJob.class);

    @Override
    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        ICommonsList<FailedMailData> iCommonsList = PhotonCoreManager.getFailedMailQueue().removeAll();
        if (!iCommonsList.isEmpty()) {
            LOGGER.info("Resending " + iCommonsList.size() + " failed mails!");
            for (FailedMailData failedMailData : iCommonsList) {
                ScopedMailAPI.getInstance().queueMail(failedMailData.getSMTPSettings(), failedMailData.getEmailData());
            }
        }
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull SimpleScheduleBuilder simpleScheduleBuilder) {
        ValueEnforcer.notNull(simpleScheduleBuilder, "ScheduleBuilder");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        return GlobalQuartzScheduler.getInstance().scheduleJob(FailedMailResendJob.class.getName(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule(simpleScheduleBuilder), FailedMailResendJob.class, commonsHashMap);
    }
}

