/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.locale;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.locale.ILocaleManager;
import com.helger.photon.core.locale.LocaleManager;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GlobalLocaleManager
extends AbstractGlobalWebSingleton
implements ILocaleManager {
    private final LocaleManager m_aInstance = new LocaleManager();

    @Deprecated
    @UsedViaReflection
    public GlobalLocaleManager() {
    }

    @Nonnull
    public static GlobalLocaleManager getInstance() {
        return GlobalLocaleManager.getGlobalSingleton(GlobalLocaleManager.class);
    }

    @Override
    @Nonnull
    public EChange registerLocale(@Nonnull Locale locale) {
        return this.m_aInstance.registerLocale(locale);
    }

    @Override
    @Nonnull
    public EChange setDefaultLocale(@Nonnull Locale locale) {
        return this.m_aInstance.setDefaultLocale(locale);
    }

    @Override
    @Nullable
    public Locale getDefaultLocale() {
        return this.m_aInstance.getDefaultLocale();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllAvailableLocales() {
        return this.m_aInstance.getAllAvailableLocales();
    }

    @Override
    public boolean hasLocales() {
        return this.m_aInstance.hasLocales();
    }

    @Override
    public boolean isSupportedLocale(@Nullable Locale locale) {
        return this.m_aInstance.isSupportedLocale(locale);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Instance", this.m_aInstance).getToString();
    }
}

