/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.locale;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.locale.ILocaleManager;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LocaleManager
implements ILocaleManager {
    private final ICommonsOrderedSet<Locale> m_aLocales = new CommonsLinkedHashSet<Locale>();
    private Locale m_aDefaultLocale;

    @Override
    @Nonnull
    public EChange registerLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "Locale");
        if (!this.m_aLocales.add(locale)) {
            return EChange.UNCHANGED;
        }
        if (this.m_aLocales.size() == 1) {
            this.setDefaultLocale(locale);
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange setDefaultLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "DefaultLocale");
        ValueEnforcer.isTrue(this.m_aLocales.contains(locale), () -> "The supposed default locale " + locale + " is not a valid application locale! It needs to be registered before it can be set as a default.");
        if (locale.equals(this.m_aDefaultLocale)) {
            return EChange.UNCHANGED;
        }
        this.m_aDefaultLocale = locale;
        return EChange.UNCHANGED;
    }

    @Override
    @Nullable
    public Locale getDefaultLocale() {
        return this.m_aDefaultLocale;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllAvailableLocales() {
        return this.m_aLocales.getCopyAsList();
    }

    @Override
    public boolean hasLocales() {
        return this.m_aLocales.isNotEmpty();
    }

    @Override
    public boolean isSupportedLocale(@Nullable Locale locale) {
        return this.m_aLocales.contains(locale);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Locales", this.m_aLocales).append("DefaultLocale", this.m_aDefaultLocale).getToString();
    }
}

