/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.login;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.login.LoginInfo;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginManager {
    public static final String LOGIN_INFO_REMOTE_ADDRESS = "remote-address";
    public static final String LOGIN_INFO_REMOTE_HOST = "remote-host";
    public static final String LOGIN_INFO_REQUEST_URI = "request-uri";
    public static final String LOGIN_INFO_QUERY_STRING = "query-string";
    public static final String LOGIN_INFO_USER_AGENT = "user-agent";
    public static final String LOGIN_INFO_REQUEST_COUNT = "request-count";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLoginManager.class);
    private ICommonsCollection<String> m_aRequiredRoleIDs;

    public void setRequiredRoleIDs(@Nullable Collection<String> collection) {
        this.m_aRequiredRoleIDs = collection == null ? null : new CommonsHashSet<Collection<String>>(collection);
    }

    @OverrideOnDemand
    protected abstract IHTMLProvider createLoginScreen(boolean var1, @Nonnull ICredentialValidationResult var2);

    @OverrideOnDemand
    protected boolean isLoginInProgress(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return "validate-login-credentials".equals(iRequestWebScopeWithoutResponse.params().getAsString("login-action"));
    }

    @Nullable
    @OverrideOnDemand
    protected String getLoginName(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return iRequestWebScopeWithoutResponse.params().getAsString("userid");
    }

    @Nullable
    @OverrideOnDemand
    protected String getPassword(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return iRequestWebScopeWithoutResponse.params().getAsString("password");
    }

    @Nullable
    @OverrideOnDemand
    protected IUser getUserOfLoginName(@Nullable String string) {
        return PhotonSecurityManager.getUserMgr().getUserOfLoginName(string);
    }

    @OverrideOnDemand
    protected void modifyLoginInfo(@Nonnull LoginInfo loginInfo, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, boolean bl) {
        loginInfo.attrs().putIn(LOGIN_INFO_REMOTE_ADDRESS, iRequestWebScopeWithoutResponse.getRemoteAddr());
        loginInfo.attrs().putIn(LOGIN_INFO_REMOTE_HOST, iRequestWebScopeWithoutResponse.getRemoteHost());
        loginInfo.attrs().putIn(LOGIN_INFO_REQUEST_URI, iRequestWebScopeWithoutResponse.getRequestURIEncoded());
        loginInfo.attrs().putIn(LOGIN_INFO_QUERY_STRING, iRequestWebScopeWithoutResponse.getQueryString());
        loginInfo.attrs().putIn(LOGIN_INFO_USER_AGENT, iRequestWebScopeWithoutResponse.getUserAgent().getAsString());
        loginInfo.attrs().putIn(LOGIN_INFO_REQUEST_COUNT, Integer.toString(loginInfo.attrs().getAsInt(LOGIN_INFO_REQUEST_COUNT, 0) + 1));
    }

    @Nonnull
    public final EContinue checkUserAndShowLogin(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        LoginInfo loginInfo;
        LoggedInUserManager loggedInUserManager = LoggedInUserManager.getInstance();
        String string = loggedInUserManager.getCurrentUserID();
        boolean bl = false;
        if (string == null) {
            Object object;
            boolean bl2 = false;
            ELoginResult eLoginResult = ELoginResult.SUCCESS;
            if (this.isLoginInProgress(iRequestWebScopeWithoutResponse)) {
                object = this.getLoginName(iRequestWebScopeWithoutResponse);
                String string2 = this.getPassword(iRequestWebScopeWithoutResponse);
                IUser iUser = this.getUserOfLoginName((String)object);
                eLoginResult = loggedInUserManager.loginUser(iUser, string2, this.m_aRequiredRoleIDs);
                if (eLoginResult.isSuccess()) {
                    string = (String)iUser.getID();
                    bl = true;
                } else {
                    if (GlobalDebug.isDebugMode()) {
                        LOGGER.warn("Login of '" + (String)object + "' failed because " + eLoginResult);
                    }
                    boolean bl3 = bl2 = StringHelper.hasText((String)object) || StringHelper.hasText(string2);
                }
            }
            if (string == null) {
                object = this.createLoginScreen(bl2, eLoginResult);
                PhotonHTMLHelper.createHTMLResponse(iRequestWebScopeWithoutResponse, unifiedResponse, (IHTMLProvider)object);
            }
        }
        if ((loginInfo = loggedInUserManager.getLoginInfo(string)) != null) {
            loginInfo.setLastAccessDTNow();
            this.modifyLoginInfo(loginInfo, iRequestWebScopeWithoutResponse, bl);
        } else if (string != null) {
            LOGGER.error("Failed to resolve LoginInfo of user ID '" + string + "'");
        }
        if (bl) {
            unifiedResponse.setRedirect(iRequestWebScopeWithoutResponse.getURLEncoded());
            return EContinue.BREAK;
        }
        return EContinue.valueOf(string != null);
    }
}

