/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.photon.core.longrun.LongRunningJobResult;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LongRunningJobData
implements IHasID<String>,
Serializable {
    private final String m_sID;
    private final IMultilingualText m_aJobDescription;
    private final LocalDateTime m_aStartDateTime;
    private final String m_sStartingUserID;
    private LocalDateTime m_aEndDateTime;
    private ESuccess m_eExecSuccess;
    private LongRunningJobResult m_aResult;

    public LongRunningJobData(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable String string2) {
        this.m_sID = ValueEnforcer.notEmpty(string, "JobID");
        this.m_aJobDescription = ValueEnforcer.notNull(iMultilingualText, "JobDescription");
        this.m_aStartDateTime = PDTFactory.getCurrentLocalDateTime();
        this.m_sStartingUserID = string2;
    }

    LongRunningJobData(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull LocalDateTime localDateTime2, @Nonnull ESuccess eSuccess, @Nullable String string2, @Nonnull IMultilingualText iMultilingualText, @Nonnull LongRunningJobResult longRunningJobResult) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_aStartDateTime = ValueEnforcer.notNull(localDateTime, "StartDateTime");
        this.m_aEndDateTime = ValueEnforcer.notNull(localDateTime2, "EndDateTime");
        this.m_eExecSuccess = ValueEnforcer.notNull(eSuccess, "ExecSuccess");
        this.m_sStartingUserID = string2;
        this.m_aJobDescription = ValueEnforcer.notNull(iMultilingualText, "JobDescription");
        this.m_aResult = ValueEnforcer.notNull(longRunningJobResult, "Result");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMultilingualText getJobDescription() {
        return this.m_aJobDescription;
    }

    @Nonnull
    public LocalDateTime getStartDateTime() {
        return this.m_aStartDateTime;
    }

    @Nullable
    public String getStartingUserID() {
        return this.m_sStartingUserID;
    }

    void onJobEnd(@Nonnull ESuccess eSuccess, @Nonnull LongRunningJobResult longRunningJobResult) {
        ValueEnforcer.notNull(eSuccess, "ExecSuccess");
        ValueEnforcer.notNull(longRunningJobResult, "Result");
        if (this.isEnded()) {
            throw new IllegalStateException("Job was already ended");
        }
        this.m_aEndDateTime = PDTFactory.getCurrentLocalDateTime();
        this.m_eExecSuccess = eSuccess;
        this.m_aResult = longRunningJobResult;
        if (this.m_aResult == null) {
            throw new IllegalStateException("Failed to create job results object!");
        }
    }

    public boolean isEnded() {
        return this.m_aEndDateTime != null;
    }

    @Nullable
    public LocalDateTime getEndDateTime() {
        return this.m_aEndDateTime;
    }

    @Nonnull
    public Duration getDuration() {
        if (!this.isEnded()) {
            throw new IllegalStateException("Job is still running!");
        }
        return Duration.between(this.m_aStartDateTime, this.getEndDateTime());
    }

    @Nullable
    public ESuccess getExecutionSuccess() {
        return this.m_eExecSuccess;
    }

    @Nullable
    public LongRunningJobResult getResult() {
        return this.m_aResult;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("jobDescription", this.m_aJobDescription).append("startDateTime", this.m_aStartDateTime).append("startingUserID", this.m_sStartingUserID).append("endDateTime", this.m_aEndDateTime).append("execSucces", this.m_eExecSuccess).append("result", this.m_aResult).getToString();
    }
}

