/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringParser;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.ReadOnlyMultilingualText;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.core.longrun.ELongRunningJobResultType;
import com.helger.photon.core.longrun.LongRunningJobData;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.File;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LongRunningJobDataMicroTypeConverter
implements IMicroTypeConverter<LongRunningJobData> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_STARTDT = "startdt";
    private static final String ATTR_ENDDT = "enddt";
    private static final String ATTR_EXECSUCCESS = "execsuccess";
    private static final String ATTR_STARTINGUSERID = "startinguserid";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_RESULT = "result";
    private static final String ATTR_TYPE = "type";

    @Override
    @Nullable
    public IMicroElement convertToMicroElement(@Nonnull LongRunningJobData longRunningJobData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, longRunningJobData.getID());
        microElement.setAttributeWithConversion(ATTR_STARTDT, (Object)longRunningJobData.getStartDateTime());
        microElement.setAttributeWithConversion(ATTR_ENDDT, (Object)longRunningJobData.getEndDateTime());
        microElement.setAttribute(ATTR_EXECSUCCESS, Boolean.toString(longRunningJobData.getExecutionSuccess().isSuccess()));
        if (longRunningJobData.getStartingUserID() != null) {
            microElement.setAttribute(ATTR_STARTINGUSERID, longRunningJobData.getStartingUserID());
        }
        microElement.appendChild(MicroTypeConverter.convertToMicroElement(longRunningJobData.getJobDescription(), string, ELEMENT_DESCRIPTION));
        IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_RESULT);
        iMicroElement.setAttribute(ATTR_TYPE, longRunningJobData.getResult().getType().getID());
        iMicroElement.appendText(longRunningJobData.getResult().getAsString());
        return null;
    }

    @Override
    @Nullable
    public LongRunningJobData convertToNative(@Nonnull IMicroElement iMicroElement) {
        LongRunningJobResult longRunningJobResult;
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        LocalDateTime localDateTime = iMicroElement.getAttributeValueWithConversion(ATTR_STARTDT, LocalDateTime.class);
        LocalDateTime localDateTime2 = iMicroElement.getAttributeValueWithConversion(ATTR_ENDDT, LocalDateTime.class);
        ESuccess eSuccess = ESuccess.valueOf(StringParser.parseBool(iMicroElement.getAttributeValue(ATTR_EXECSUCCESS)));
        String string2 = iMicroElement.getAttributeValue(ATTR_STARTINGUSERID);
        IMultilingualText iMultilingualText = MicroTypeConverter.convertToNative(iMicroElement.getFirstChildElement(ELEMENT_DESCRIPTION), ReadOnlyMultilingualText.class);
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_RESULT);
        ELongRunningJobResultType eLongRunningJobResultType = ELongRunningJobResultType.getFromIDOrNull(iMicroElement2.getAttributeValue(ATTR_TYPE));
        String string3 = iMicroElement2.getTextContent();
        switch (eLongRunningJobResultType) {
            case FILE: {
                longRunningJobResult = LongRunningJobResult.createFile(new File(string3));
                break;
            }
            case XML: {
                longRunningJobResult = LongRunningJobResult.createXML(MicroReader.readMicroXML(string3));
                break;
            }
            case TEXT: {
                longRunningJobResult = LongRunningJobResult.createText(string3);
                break;
            }
            case LINK: {
                longRunningJobResult = LongRunningJobResult.createLink(new SimpleURL(string3));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + eLongRunningJobResultType);
            }
        }
        return new LongRunningJobData(string, localDateTime, localDateTime2, eSuccess, string2, iMultilingualText, longRunningJobResult);
    }
}

