/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.state.ESuccess;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.photon.core.longrun.LongRunningJobData;
import com.helger.photon.core.longrun.LongRunningJobResult;
import com.helger.photon.core.longrun.LongRunningJobResultManager;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LongRunningJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongRunningJobManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, LongRunningJobData> m_aRunningJobs = new CommonsHashMap<String, LongRunningJobData>();
    private final LongRunningJobResultManager m_aResultMgr;

    public LongRunningJobManager(@Nonnull LongRunningJobResultManager longRunningJobResultManager) {
        this.m_aResultMgr = ValueEnforcer.notNull(longRunningJobResultManager, "ResultMgr");
    }

    @Nonnull
    @Nonempty
    public String onStartJob(@Nonnull ILongRunningJob iLongRunningJob, @Nullable String string) {
        ValueEnforcer.notNull(iLongRunningJob, "Job");
        String string2 = GlobalIDFactory.getNewStringID();
        LongRunningJobData longRunningJobData = new LongRunningJobData(string2, iLongRunningJob.getJobDescription(), string);
        this.m_aRWLock.writeLockedGet(() -> this.m_aRunningJobs.put(string2, longRunningJobData));
        return string2;
    }

    public void onEndJob(@Nullable String string, @Nonnull ESuccess eSuccess, @Nonnull LongRunningJobResult longRunningJobResult) {
        ValueEnforcer.notNull(eSuccess, "ExecSuccess");
        ValueEnforcer.notNull(longRunningJobResult, "Result");
        LongRunningJobData longRunningJobData = this.m_aRWLock.writeLockedGet(() -> {
            LongRunningJobData longRunningJobData = (LongRunningJobData)this.m_aRunningJobs.remove(string);
            if (longRunningJobData == null) {
                throw new IllegalArgumentException("Illegal job ID '" + string + "' passed!");
            }
            longRunningJobData.onJobEnd(eSuccess, longRunningJobResult);
            return longRunningJobData;
        });
        this.m_aResultMgr.addResult(longRunningJobData);
    }

    @Nonnegative
    public int getRunningJobCount() {
        return this.m_aRWLock.readLockedInt(this.m_aRunningJobs::size);
    }

    @Nonnull
    @Nonempty
    public ICommonsCollection<LongRunningJobData> getAllRunningJobs() {
        return this.m_aRWLock.readLockedGet(this.m_aRunningJobs::copyOfValues);
    }

    public void waitUntilAllJobsAreFinished() throws InterruptedException {
        int n;
        int n2 = 1;
        while ((n = this.getRunningJobCount()) != 0) {
            LOGGER.error("There are still " + n + " long running jobs in the background! Waiting for them to finish...");
            Thread.sleep((long)n2 * 1000L);
            if (n2 >= 10) continue;
            ++n2;
        }
    }
}

