/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.photon.core.longrun.ELongRunningJobResultType;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongRunningJobResult
implements Serializable {
    private final ELongRunningJobResultType m_eType;
    private final Serializable m_aResult;

    protected LongRunningJobResult(@Nonnull ELongRunningJobResultType eLongRunningJobResultType, @Nonnull Serializable serializable) {
        ValueEnforcer.notNull(eLongRunningJobResultType, "Type");
        ValueEnforcer.notNull(serializable, "Result");
        this.m_eType = eLongRunningJobResultType;
        this.m_aResult = serializable;
    }

    @Nonnull
    public ELongRunningJobResultType getType() {
        return this.m_eType;
    }

    @Nonnull
    public Serializable getResultObject() {
        return this.m_aResult;
    }

    @Nullable
    public File getResultFile() {
        return this.getType().equals(ELongRunningJobResultType.FILE) ? (File)this.m_aResult : null;
    }

    @Nullable
    public IMicroNode getResultXML() {
        return this.getType().equals(ELongRunningJobResultType.XML) ? (IMicroNode)this.m_aResult : null;
    }

    @Nullable
    public String getResultText() {
        return this.getType().equals(ELongRunningJobResultType.TEXT) ? (String)((Object)this.m_aResult) : null;
    }

    @Nullable
    public ISimpleURL getResultLink() {
        return this.getType().equals(ELongRunningJobResultType.LINK) ? (ISimpleURL)this.m_aResult : null;
    }

    @Nonnull
    public String getAsString() {
        switch (this.m_eType) {
            case FILE: {
                return this.getResultFile().getAbsolutePath();
            }
            case XML: {
                return MicroWriter.getNodeAsString(this.getResultXML());
            }
            case TEXT: {
                return this.getResultText();
            }
            case LINK: {
                return this.getResultLink().getAsStringWithEncodedParameters();
            }
        }
        throw new IllegalStateException("Unhandled type: " + this.m_eType);
    }

    public String toString() {
        return new ToStringGenerator(this).append("type", this.m_eType).append("result", this.m_aResult).getToString();
    }

    @Nonnull
    public static LongRunningJobResult createFile(@Nonnull File file) {
        return new LongRunningJobResult(ELongRunningJobResultType.FILE, file);
    }

    @Nonnull
    public static LongRunningJobResult createXML(@Nonnull IMicroNode iMicroNode) {
        return new LongRunningJobResult(ELongRunningJobResultType.XML, iMicroNode);
    }

    @Nonnull
    public static LongRunningJobResult createText(@Nonnull String string) {
        return new LongRunningJobResult(ELongRunningJobResultType.TEXT, (Serializable)((Object)string));
    }

    @Nonnull
    public static LongRunningJobResult createLink(@Nonnull ISimpleURL iSimpleURL) {
        return new LongRunningJobResult(ELongRunningJobResultType.LINK, iSimpleURL);
    }
}

