/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.longrun;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.dao.wal.AbstractMapBasedWALDAO;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.core.longrun.LongRunningJobData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LongRunningJobResultManager
extends AbstractPhotonMapBasedWALDAO<LongRunningJobData, LongRunningJobData> {
    public LongRunningJobResultManager(@Nonnull @Nonempty String string) throws DAOException {
        super(LongRunningJobData.class, string, new AbstractMapBasedWALDAO.InitSettings().setOrderedMapSupplier());
    }

    public void addResult(@Nonnull LongRunningJobData longRunningJobData) {
        ValueEnforcer.notNull(longRunningJobData, "JobData");
        if (!longRunningJobData.isEnded()) {
            throw new IllegalArgumentException("Passed jobData is not yet finished");
        }
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(longRunningJobData));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends LongRunningJobData> getAllJobResults() {
        return this.getAll();
    }

    @Nullable
    public LongRunningJobData getJobResultOfID(@Nullable String string) {
        return (LongRunningJobData)this.getOfID(string);
    }
}

