/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuObjectFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMenuObject<IMPLTYPE extends AbstractMenuObject<IMPLTYPE>>
implements IMenuObject,
IGenericImplTrait<IMPLTYPE> {
    private final String m_sID;
    private IMenuObjectFilter m_aDisplayFilter;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    public AbstractMenuObject(@Nonnull @Nonempty String string) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    public final IMPLTYPE setDisplayFilter(@Nullable IMenuObjectFilter iMenuObjectFilter) {
        this.m_aDisplayFilter = iMenuObjectFilter;
        return (IMPLTYPE)((AbstractMenuObject)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMenuObjectFilter getDisplayFilter() {
        return this.m_aDisplayFilter;
    }

    @Override
    public final boolean matchesDisplayFilter() {
        return this.m_aDisplayFilter == null || this.m_aDisplayFilter.test(this);
    }

    @Nonnull
    @ReturnsMutableObject
    public final AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractMenuObject abstractMenuObject = (AbstractMenuObject)object;
        return this.m_sID.equals(abstractMenuObject.m_sID);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sID).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("ID", this.m_sID).appendIfNotNull("DisplayFilter", this.m_aDisplayFilter).append("Attrs", this.m_aAttrs).getToString();
    }
}

