/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.photon.core.menu.IMenuObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IMenuObjectFilter
extends IPredicate<IMenuObject>,
IHasDisplayText {
    @Override
    @Nullable
    default public String getDisplayText(@Nonnull Locale locale) {
        return null;
    }

    @Nonnull
    default public IMenuObjectFilter and(final @Nonnull IMenuObjectFilter iMenuObjectFilter) {
        ValueEnforcer.notNull(iMenuObjectFilter, "Other");
        final IMenuObjectFilter iMenuObjectFilter2 = this;
        return new IMenuObjectFilter(){

            @Override
            public boolean test(IMenuObject iMenuObject) {
                return iMenuObjectFilter2.test(iMenuObject) && iMenuObjectFilter.test(iMenuObject);
            }

            @Override
            @Nullable
            public String getDisplayText(@Nonnull Locale locale) {
                return StringHelper.getConcatenatedOnDemand(iMenuObjectFilter2.getDisplayText(locale), " + ", iMenuObjectFilter.getDisplayText(locale));
            }
        };
    }

    @Nonnull
    default public IMenuObjectFilter or(final @Nonnull IMenuObjectFilter iMenuObjectFilter) {
        ValueEnforcer.notNull(iMenuObjectFilter, "Other");
        final IMenuObjectFilter iMenuObjectFilter2 = this;
        return new IMenuObjectFilter(){

            @Override
            public boolean test(IMenuObject iMenuObject) {
                return iMenuObjectFilter2.test(iMenuObject) || iMenuObjectFilter.test(iMenuObject);
            }

            @Override
            @Nullable
            public String getDisplayText(@Nonnull Locale locale) {
                return StringHelper.getNotNull(iMenuObjectFilter2.getDisplayText(locale), iMenuObjectFilter.getDisplayText(locale));
            }
        };
    }
}

