/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.url.IHasSimpleURL;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemExternal;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MenuItemExternal
extends AbstractMenuObject<MenuItemExternal>
implements IMenuItemExternal {
    private final IHasSimpleURL m_aURLProvider;
    private final IHasDisplayText m_aDisplayText;
    private String m_sTarget;

    public MenuItemExternal(@Nonnull @Nonempty String string, @Nonnull IHasSimpleURL iHasSimpleURL, @Nonnull IHasDisplayText iHasDisplayText) {
        super(string);
        this.m_aURLProvider = ValueEnforcer.notNull(iHasSimpleURL, "URL");
        this.m_aDisplayText = ValueEnforcer.notNull(iHasDisplayText, "DisplayText");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.EXTERNAL;
    }

    @Override
    @Nonnull
    public final IHasSimpleURL getURLProvider() {
        return this.m_aURLProvider;
    }

    @Override
    @Nullable
    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public final String getTarget() {
        return this.m_sTarget;
    }

    @Override
    @Nonnull
    public final MenuItemExternal setTarget(@Nullable String string) {
        this.m_sTarget = string;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemExternal menuItemExternal = (MenuItemExternal)object;
        return this.m_aURLProvider.equals(menuItemExternal.m_aURLProvider);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aURLProvider).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("URLProvider", this.m_aURLProvider).append("DisplayText", this.m_aDisplayText).append("Target", this.m_sTarget).getToString();
    }
}

