/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.page.IPage;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MenuItemPage
extends AbstractMenuObject<MenuItemPage>
implements IMenuItemPage {
    private final IPage m_aPage;
    private final IHasDisplayText m_aDisplayText;
    private String m_sTarget;

    public MenuItemPage(@Nonnull @Nonempty String string, @Nonnull IPage iPage) {
        this(string, iPage, iPage);
    }

    public MenuItemPage(@Nonnull @Nonempty String string, @Nonnull IPage iPage, @Nonnull IHasDisplayText iHasDisplayText) {
        super(string);
        this.m_aPage = ValueEnforcer.notNull(iPage, "Page");
        this.m_aDisplayText = ValueEnforcer.notNull(iHasDisplayText, "DisplayText");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.PAGE;
    }

    @Override
    @Nonnull
    public IPage getPage() {
        return this.m_aPage;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public String getTarget() {
        return this.m_sTarget;
    }

    @Override
    @Nonnull
    public MenuItemPage setTarget(@Nullable String string) {
        this.m_sTarget = string;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemPage menuItemPage = (MenuItemPage)object;
        return ((String)this.m_aPage.getID()).equals(menuItemPage.m_aPage.getID());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aPage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Page", this.m_aPage).append("DisplayText", this.m_aDisplayText).append("Target", this.m_sTarget).getToString();
    }
}

