/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.menu.AbstractMenuObject;
import com.helger.photon.core.menu.EMenuObjectType;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuItemRedirectToPage;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MenuItemRedirectToPage
extends AbstractMenuObject<MenuItemRedirectToPage>
implements IMenuItemRedirectToPage {
    private final IMenuItemPage m_aMenuItemPage;

    public MenuItemRedirectToPage(@Nonnull @Nonempty String string, @Nonnull IMenuItemPage iMenuItemPage) {
        super(string);
        this.m_aMenuItemPage = ValueEnforcer.notNull(iMenuItemPage, "MenuItemPage");
    }

    @Override
    @Nonnull
    public final EMenuObjectType getMenuObjectType() {
        return EMenuObjectType.REDIRECT_TO_PAGE;
    }

    @Override
    @Nonnull
    public IMenuItemPage getTargetMenuItemPage() {
        return this.m_aMenuItemPage;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        MenuItemRedirectToPage menuItemRedirectToPage = (MenuItemRedirectToPage)object;
        return ((String)this.m_aMenuItemPage.getID()).equals(menuItemRedirectToPage.m_aMenuItemPage.getID());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aMenuItemPage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("MenuItemPage", this.m_aMenuItemPage).getToString();
    }
}

