/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.filter.AbstractMenuObjectFilter;
import com.helger.photon.security.util.SecurityHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MenuObjectFilterUserAssignedToUserGroup
extends AbstractMenuObjectFilter {
    private final String m_sUserGroupID;

    public MenuObjectFilterUserAssignedToUserGroup(@Nonnull @Nonempty String string) {
        this.m_sUserGroupID = ValueEnforcer.notEmpty(string, "UserGroupID");
    }

    @Nonnull
    @Nonempty
    public String getUserGroupID() {
        return this.m_sUserGroupID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return EPhotonCoreText.MENU_OBJECT_FILTER_USER_ASSIGNED_TO_GROUP.getDisplayTextWithArgs(locale, this.m_sUserGroupID);
    }

    @Override
    public boolean test(@Nullable IMenuObject iMenuObject) {
        return SecurityHelper.isCurrentUserAssignedToUserGroup(this.m_sUserGroupID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("userGroupID", this.m_sUserGroupID).getToString();
    }
}

