/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.menu.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.filter.AbstractMenuObjectFilter;
import com.helger.photon.security.util.SecurityHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MenuObjectFilterUserHasRole
extends AbstractMenuObjectFilter {
    private final String m_sRoleID;

    public MenuObjectFilterUserHasRole(@Nonnull @Nonempty String string) {
        this.m_sRoleID = ValueEnforcer.notEmpty(string, "RoleID");
    }

    @Nonnull
    @Nonempty
    public String getRoleID() {
        return this.m_sRoleID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return EPhotonCoreText.MENU_OBJECT_FILTER_USER_HAS_ROLE.getDisplayTextWithArgs(locale, this.m_sRoleID);
    }

    @Override
    public boolean test(@Nullable IMenuObject iMenuObject) {
        return SecurityHelper.hasCurrentUserRole(this.m_sRoleID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("roleID", this.m_sRoleID).getToString();
    }
}

