/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.mgr;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassHelper;
import com.helger.photon.core.favorites.FavoriteManager;
import com.helger.photon.core.longrun.LongRunningJobManager;
import com.helger.photon.core.longrun.LongRunningJobResultManager;
import com.helger.photon.core.sysmigration.SystemMigrationManager;
import com.helger.photon.core.systemmsg.SystemMessageManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonBasicManager
extends AbstractGlobalSingleton {
    public static final String DIRECTORY_HTML = "html/";
    public static final String FAVORITES_XML = "favorites.xml";
    public static final String LONG_RUNNING_JOB_RESULTS_XML = "long-running-job-results.xml";
    public static final String SYSTEM_MIGRATIONS_XML = "systemmigrations.xml";
    public static final String SYSTEM_MESSAGE_XML = "systemmessage.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonBasicManager.class);
    private FavoriteManager m_aFavoriteManager;
    private LongRunningJobManager m_aLongRunningJobMgr;
    private LongRunningJobResultManager m_aLongRunningJobResultMgr;
    private SystemMessageManager m_aSystemMessageMgr;
    private SystemMigrationManager m_aSystemMigrationMgr;

    @Deprecated
    @UsedViaReflection
    public PhotonBasicManager() {
    }

    @Override
    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            this.m_aFavoriteManager = new FavoriteManager(FAVORITES_XML);
            this.m_aSystemMigrationMgr = new SystemMigrationManager(SYSTEM_MIGRATIONS_XML);
            this.m_aSystemMessageMgr = new SystemMessageManager(SYSTEM_MESSAGE_XML);
            this.m_aLongRunningJobResultMgr = new LongRunningJobResultManager(LONG_RUNNING_JOB_RESULTS_XML);
            this.m_aLongRunningJobMgr = new LongRunningJobManager(this.m_aLongRunningJobResultMgr);
            LOGGER.info(ClassHelper.getClassLocalName(this) + " was initialized");
        }
        catch (Throwable throwable) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName(this), throwable);
        }
    }

    @Nonnull
    public static PhotonBasicManager getInstance() {
        return PhotonBasicManager.getGlobalSingleton(PhotonBasicManager.class);
    }

    @Nonnull
    public static FavoriteManager getFavoriteManager() {
        return PhotonBasicManager.getInstance().m_aFavoriteManager;
    }

    @Nonnull
    public static SystemMigrationManager getSystemMigrationMgr() {
        return PhotonBasicManager.getInstance().m_aSystemMigrationMgr;
    }

    @Nonnull
    public static SystemMessageManager getSystemMessageMgr() {
        return PhotonBasicManager.getInstance().m_aSystemMessageMgr;
    }

    @Nonnull
    public static LongRunningJobResultManager getLongRunningJobResultMgr() {
        return PhotonBasicManager.getInstance().m_aLongRunningJobResultMgr;
    }

    @Nonnull
    public static LongRunningJobManager getLongRunningJobMgr() {
        return PhotonBasicManager.getInstance().m_aLongRunningJobMgr;
    }
}

