/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.mock;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.photon.core.servlet.WebAppListener;
import com.helger.servlet.mock.MockHttpListener;
import com.helger.servlet.mock.MockServletContext;
import com.helger.web.scope.mock.MockServletRequestListenerScopeAware;
import com.helger.web.scope.mock.WebScopeTestRule;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PhotonCoreTestRule
extends WebScopeTestRule {
    public static final File RESOURCE_BASE_FILE = new File("target/test-classes").getAbsoluteFile();

    @Nonnull
    @ReturnsMutableCopy
    public static StringMap createDefaultServletContextInitParameters() {
        return new StringMap().add("noStartupInfo", true).add("noCheckFileAccess", true);
    }

    public PhotonCoreTestRule() {
        this(PhotonCoreTestRule.createDefaultServletContextInitParameters());
    }

    public PhotonCoreTestRule(@Nullable ICommonsMap<String, String> iCommonsMap) {
        super(iCommonsMap);
    }

    @Override
    protected void initListener() {
        MockHttpListener.removeAllDefaultListeners();
        WebAppListener webAppListener = new WebAppListener();
        webAppListener.setHandleStatisticsOnEnd(false);
        MockHttpListener.addDefaultListener(webAppListener);
        MockHttpListener.addDefaultListener(new MockServletRequestListenerScopeAware());
        MockHttpListener.setCurrentToDefault();
    }

    @Override
    @Nonnull
    protected MockServletContext createMockServletContext(@Nullable String string, @Nullable Map<String, String> map) {
        return MockServletContext.create(string, RESOURCE_BASE_FILE.getAbsolutePath(), null, map);
    }
}

