/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.page;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.ReadOnlyMultilingualText;
import com.helger.photon.core.page.IPage;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractPage
implements IPage {
    private final String m_sID;
    private IMultilingualText m_aName;
    private IMultilingualText m_aDescription;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    @Nullable
    public static ReadOnlyMultilingualText getAsMLT(@Nullable String string) {
        return string == null ? null : new ReadOnlyMultilingualText(LocaleHelper.LOCALE_INDEPENDENT, string);
    }

    public AbstractPage(@Nonnull @Nonempty String string) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this(string, AbstractPage.getAsMLT(string2));
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        this(string, AbstractPage.getAsMLT(string2), AbstractPage.getAsMLT(string3));
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText) {
        this(string, iMultilingualText, null);
    }

    public AbstractPage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        this(string);
        this.setName(iMultilingualText);
        this.setDescription(iMultilingualText2);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    public final void setName(@Nonnull IMultilingualText iMultilingualText) {
        this.m_aName = ValueEnforcer.notNull(iMultilingualText, "Name");
    }

    @Nonnull
    public final IMultilingualText getName() {
        return this.m_aName;
    }

    @Override
    @Nullable
    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName == null ? null : this.m_aName.getText(locale);
    }

    public final void setDescription(@Nullable IMultilingualText iMultilingualText) {
        this.m_aDescription = iMultilingualText;
    }

    @Nullable
    public final IMultilingualText getDescription() {
        return this.m_aDescription;
    }

    @Override
    @Nullable
    public final String getDescription(@Nonnull Locale locale) {
        return this.m_aDescription == null ? null : this.m_aDescription.getText(locale);
    }

    @Nonnull
    @ReturnsMutableObject
    public final AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).appendIfNotNull("Name", this.m_aName).appendIfNotNull("Description", this.m_aDescription).appendIf("Attrs", this.m_aAttrs, ICommonsMap::isNotEmpty).getToString();
    }
}

