/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.requestparam.IRequestParameterHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractRequestParameterHandlerNamed
implements IRequestParameterHandler {
    public static final String DEFAULT_REQUEST_PARAMETER_DISPLAY_LOCALE = "locale";
    public static final String DEFAULT_REQUEST_PARAMETER_MENUITEM = "menuitem";
    private String m_sRequestParamNameLocale = "locale";
    private String m_sRequestParamNameMenuItem = "menuitem";

    public abstract boolean isValidParameterName(@Nonnull String var1);

    @Nonnull
    @Nonempty
    public final String getRequestParamNameLocale() {
        return this.m_sRequestParamNameLocale;
    }

    @Nonnull
    public final AbstractRequestParameterHandlerNamed setRequestParamNameLocale(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "RequestParamNameLocale");
        ValueEnforcer.isTrue(this.isValidParameterName(string), () -> "Request parameter name '" + string + "' is invalid!");
        this.m_sRequestParamNameLocale = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getRequestParamNameMenuItem() {
        return this.m_sRequestParamNameMenuItem;
    }

    @Nonnull
    public final AbstractRequestParameterHandlerNamed setRequestParamNameMenuItem(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "RequestParamNameMenuItem");
        ValueEnforcer.isTrue(this.isValidParameterName(string), () -> "Request parameter name '" + string + "' is invalid!");
        this.m_sRequestParamNameMenuItem = string;
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ParameterNameLocale", this.m_sRequestParamNameLocale).append("ParameterNameMenuItem", this.m_sRequestParamNameMenuItem).getToString();
    }
}

