/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.AbstractRequestParameterHandlerNamed;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RequestParameterHandlerURLParameter
extends AbstractRequestParameterHandlerNamed {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IMenuTree iMenuTree) {
        PhotonRequestParameters photonRequestParameters = new PhotonRequestParameters();
        photonRequestParameters.setLocaleFromString(GlobalLocaleManager.getInstance(), iRequestWebScopeWithoutResponse.params().getAsString(this.getRequestParamNameLocale()));
        photonRequestParameters.setMenuItemFromString(iMenuTree, iRequestWebScopeWithoutResponse.params().getAsString(this.getRequestParamNameMenuItem()));
        return photonRequestParameters;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromURL(@Nonnull ISimpleURL iSimpleURL, @Nonnull IMenuTree iMenuTree) {
        PhotonRequestParameters photonRequestParameters = new PhotonRequestParameters();
        photonRequestParameters.setLocaleFromString(GlobalLocaleManager.getInstance(), iSimpleURL.params().getFirstParamValue(this.getRequestParamNameLocale()));
        photonRequestParameters.setMenuItemFromString(iMenuTree, iSimpleURL.params().getFirstParamValue(this.getRequestParamNameMenuItem()));
        return photonRequestParameters;
    }

    @Override
    @Nonnull
    public SimpleURL buildURL(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string, @Nullable Locale locale, @Nullable String string2) {
        SimpleURL simpleURL = new SimpleURL(iRequestWebScopeWithoutResponse != null ? iRequestWebScopeWithoutResponse.encodeURL(string) : string);
        if (locale != null) {
            simpleURL.add(this.getRequestParamNameLocale(), locale.toString());
        }
        if (StringHelper.hasText(string2)) {
            simpleURL.add(this.getRequestParamNameMenuItem(), string2);
        }
        return simpleURL;
    }

    @Override
    public boolean isValidParameterName(@Nonnull String string) {
        return string.indexOf(63) < 0 && string.indexOf(38) < 0;
    }
}

