/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.requestparam;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.IRequestParameterHandler;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class RequestParameterHandlerURLPathOrdered
implements IRequestParameterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParameterHandlerURLPathOrdered.class);

    @Nonnull
    protected PhotonRequestParameters getParametersFromPath(@Nonnull String string, @Nonnull IMenuTree iMenuTree) {
        PhotonRequestParameters photonRequestParameters = new PhotonRequestParameters();
        for (String string2 : StringHelper.getExploded('/', StringHelper.trimStartAndEnd(string, "/"))) {
            if (!photonRequestParameters.hasLocale() && photonRequestParameters.setLocaleFromString(GlobalLocaleManager.getInstance(), string2) != null || !photonRequestParameters.hasMenuItem() && photonRequestParameters.setMenuItemFromString(iMenuTree, string2) != null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Ignoring superfluous parameter '" + string2 + "'");
        }
        return photonRequestParameters;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iRequestWebScopeWithoutResponse.getPathInfo(), iMenuTree);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PhotonRequestParameters getParametersFromURL(@Nonnull ISimpleURL iSimpleURL, @Nonnull IMenuTree iMenuTree) {
        return this.getParametersFromPath(iSimpleURL.getPath(), iMenuTree);
    }

    @Override
    @Nonnull
    public SimpleURL buildURL(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string, @Nullable Locale locale, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (locale != null) {
            stringBuilder.append('/').append(locale.toString());
        }
        if (StringHelper.hasText(string2)) {
            stringBuilder.append('/').append(string2);
        }
        String string3 = stringBuilder.toString();
        return new SimpleURL(iRequestWebScopeWithoutResponse != null ? iRequestWebScopeWithoutResponse.encodeURL(string3) : string3);
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

