/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.EContinue;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.core.interror.InternalErrorBuilder;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;

public abstract class AbstractApplicationXServletHandler
implements IXServletSimpleHandler {
    protected AbstractApplicationXServletHandler() {
    }

    @OverrideOnDemand
    protected void invokeInternalErrorHandler(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Throwable throwable) {
        new InternalErrorBuilder().setThrowable(throwable).setRequestScope(iRequestWebScopeWithoutResponse).addErrorMessage("Error running application servlet " + this.getClass().getSimpleName()).handle();
    }

    @Override
    @Nonnull
    public EContinue onException(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull Throwable throwable) {
        if (!GlobalDebug.isDebugMode()) {
            this.invokeInternalErrorHandler(iRequestWebScopeWithoutResponse, throwable);
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Nonnull
    protected abstract IHTMLProvider createHTMLProvider(@Nonnull IRequestWebScopeWithoutResponse var1);

    @Override
    @OverridingMethodsMustInvokeSuper
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws IOException, ServletException {
        IHTMLProvider iHTMLProvider = this.createHTMLProvider(iRequestWebScopeWithoutResponse);
        PhotonHTMLHelper.createHTMLResponse(iRequestWebScopeWithoutResponse, unifiedResponse, iHTMLProvider);
    }
}

