/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EContinue;
import com.helger.http.EHttpVersion;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.servlets.scope.AbstractScopeAwareFilter;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractUnifiedResponseFilter
extends AbstractScopeAwareFilter {
    protected AbstractUnifiedResponseFilter() {
    }

    @Nonnull
    protected abstract EContinue handleRequest(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull UnifiedResponse var2) throws ServletException;

    @Override
    @Nonnull
    protected final EContinue doHttpFilter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull IRequestWebScope iRequestWebScope) throws IOException, ServletException {
        EHttpVersion eHttpVersion = RequestHelper.getHttpVersion(httpServletRequest);
        if (eHttpVersion == null) {
            httpServletResponse.sendError(505);
            return EContinue.BREAK;
        }
        EHttpMethod eHttpMethod = RequestHelper.getHttpMethod(httpServletRequest);
        if (eHttpMethod == null) {
            if (eHttpVersion.is10()) {
                httpServletResponse.sendError(400);
            } else {
                httpServletResponse.sendError(405);
            }
            return EContinue.BREAK;
        }
        UnifiedResponse unifiedResponse = new UnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest);
        if (this.handleRequest(iRequestWebScope, unifiedResponse).isContinue()) {
            return EContinue.CONTINUE;
        }
        unifiedResponse.applyToResponse(httpServletResponse);
        return EContinue.BREAK;
    }
}

