/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.http.EHttpVersion;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.handler.IXServletHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CSPReportingXServletHandler
implements IXServletHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSPReportingXServletHandler.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final Consumer<? super IJsonObject> m_aJsonHandler;
    private boolean m_bFilterDuplicates = true;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aBlockedURIs = new CommonsHashSet<String>();

    public CSPReportingXServletHandler() {
        this(CSPReportingXServletHandler::logCSPReport);
    }

    public CSPReportingXServletHandler(@Nonnull Consumer<? super IJsonObject> consumer) {
        this.m_aJsonHandler = ValueEnforcer.notNull(consumer, "JsonHandler");
    }

    public final boolean isFilterDuplicates() {
        return this.m_bFilterDuplicates;
    }

    public final void setFilterDuplicates(boolean bl) {
        this.m_bFilterDuplicates = bl;
    }

    public static void logCSPReport(@Nonnull IJsonObject iJsonObject) {
        LOGGER.warn("CSP report: " + iJsonObject.getAsJsonString(new JsonWriterSettings().setIndentEnabled(true)));
    }

    @Override
    public void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        byte[] byArray = StreamHelper.getAllBytes(httpServletRequest.getInputStream());
        IJson iJson = JsonReader.builder().setSource(new NonBlockingByteArrayInputStream(byArray)).read();
        if (iJson != null) {
            if (iJson.isObject()) {
                boolean bl;
                IJsonObject iJsonObject = iJson.getAsObject();
                String string = iJsonObject.getAsString("blocked-uri");
                boolean bl2 = bl = this.m_bFilterDuplicates && StringHelper.hasText(string) && this.m_aRWLock.writeLockedBoolean(() -> !this.m_aBlockedURIs.add(string));
                if (bl) {
                    LOGGER.info("Ignoring already blocked URI '" + string + "'");
                } else {
                    this.m_aJsonHandler.accept(iJson.getAsObject());
                }
            } else {
                LOGGER.error("Weird JSON received: " + iJson.getAsJsonString(new JsonWriterSettings().setIndentEnabled(true)));
            }
        } else {
            LOGGER.error("Failed to parse CSP report JSON: " + new String(byArray, StandardCharsets.ISO_8859_1));
        }
        httpServletResponse.setStatus(202);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllBlockedURIs() {
        return this.m_aRWLock.readLockedGet(this.m_aBlockedURIs::getClone);
    }

    @Nonnull
    public EChange clearAllBlockedURIs() {
        return this.m_aRWLock.readLockedGet(this.m_aBlockedURIs::removeAll);
    }
}

