/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.SimpleURL;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class ErrorXServletHandler
implements IXServletSimpleHandler {
    private final String m_sServletPath;

    public ErrorXServletHandler(String string) {
        ValueEnforcer.notEmpty(string, "ServletPath");
        ValueEnforcer.isTrue(string.startsWith("/"), "Path must start with '/'!");
        this.m_sServletPath = string;
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        HttpServletRequest httpServletRequest = iRequestWebScopeWithoutResponse.getRequest();
        SimpleURL simpleURL = new SimpleURL(iRequestWebScopeWithoutResponse.getContextPath() + this.m_sServletPath);
        simpleURL.add("httpError", true);
        simpleURL.addIf("httpStatusCode", StringHelper.getToString(httpServletRequest.getAttribute("javax.servlet.error.status_code")), Objects::nonNull);
        simpleURL.addIf("httpStatusMessage", StringHelper.getToString(httpServletRequest.getAttribute("javax.servlet.error.message")), Objects::nonNull);
        simpleURL.addIf("httpRequestUri", StringHelper.getToString(httpServletRequest.getAttribute("javax.servlet.error.request_uri")), Objects::nonNull);
        simpleURL.addIf("httpReferrer", iRequestWebScopeWithoutResponse.headers().getFirstHeaderValue("Referer"), Objects::nonNull);
        unifiedResponse.setRedirect(simpleURL);
    }
}

