/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.servlet;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.lang.ClassPathHelper;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.EJVMVendor;
import com.helger.commons.system.SystemHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.thirdparty.IThirdPartyModule;
import com.helger.commons.thirdparty.ThirdPartyModuleRegistry;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.url.URLHelper;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.html.hc.config.HCSettings;
import com.helger.photon.ajax.GlobalAjaxInvoker;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.photon.api.GlobalAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.io.WebIOLongIDFactory;
import com.helger.photon.core.CPhotonVersion;
import com.helger.photon.core.PhotonCoreInit;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.locale.ILocaleManager;
import com.helger.photon.core.smtp.AuditingEmailDataTransportListener;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.password.constraint.PasswordConstraintList;
import com.helger.photon.security.password.constraint.PasswordConstraintMinLength;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.StaticServerInfo;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.transport.listener.LoggingConnectionListener;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.util.statistics.StatisticsExporter;
import java.io.File;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppListener
implements ServletContextListener,
HttpSessionListener {
    public static final String DEFAULT_INIT_PARAMETER_DEBUG = "debug";
    public static final String DEFAULT_INIT_PARAMETER_PRODUCTION = "production";
    public static final String INIT_PARAMETER_DATA_PATH = "dataPath";
    public static final String INIT_PARAMETER_NO_STARTUP_INFO = "noStartupInfo";
    public static final String INIT_PARAMETER_SERVER_URL = "serverUrl";
    public static final String INIT_PARAMETER_SERVER_URL_PRODUCTION = "serverUrlProduction";
    public static final String INIT_PARAMETER_NO_CHECK_FILE_ACCESS = "noCheckFileAccess";
    public static final String ID_FILENAME = "persistent_id.dat";
    public static final int DEFAULT_PASSWORD_MIN_LENGTH = 6;
    private static final Logger LOGGER;
    private static final AtomicBoolean s_aOnlyOneInstanceAllowed;
    private static final AtomicBoolean s_aInited;
    private LocalDateTime m_aInitializationStartDT;
    private LocalDateTime m_aInitializationEndDT;
    private boolean m_bHandleStatisticsOnEnd = true;

    public static void setOnlyOneInstanceAllowed(boolean bl) {
        s_aOnlyOneInstanceAllowed.set(bl);
    }

    public static boolean isOnlyOneInstanceAllowed() {
        return s_aOnlyOneInstanceAllowed.get();
    }

    protected final void logLogo() {
        LOGGER.info("       _                 _              ");
        LOGGER.info(" _ __ | |__         ___ | |_ ___  _ __  ");
        LOGGER.info("| '_ \\| '_ \\ _____ / _ \\| __/ _ \\| '_ \\ ");
        LOGGER.info("| |_) | | | |_____| (_) | || (_) | | | |");
        LOGGER.info("| .__/|_| |_|      \\___/ \\__\\___/|_| |_|");
        LOGGER.info("|_|                               v" + CPhotonVersion.BUILD_VERSION);
    }

    protected final void logServerInfo(@Nonnull ServletContext servletContext) {
        LOGGER.info("Java " + SystemProperties.getJavaVersion() + " running '" + servletContext.getServletContextName() + "' on " + servletContext.getServerInfo() + " with " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB max RAM and Servlet API " + servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
        EJVMVendor eJVMVendor = EJVMVendor.getCurrentVendor();
        if (eJVMVendor.isSun() && eJVMVendor != EJVMVendor.SUN_SERVER) {
            LOGGER.warn("Consider using the Sun Server Runtime by specifiying '-server' on the commandline!");
        }
        if (this.getClass().desiredAssertionStatus()) {
            LOGGER.warn("Java assertions are enabled - this should be disabled in production!");
        }
    }

    protected final void logClassPath() {
        if (GlobalDebug.isDebugMode()) {
            ICommonsList<String> iCommonsList = ClassPathHelper.getAllClassPathEntries();
            LOGGER.info("Class path [" + iCommonsList.size() + " elements]:");
            for (String string : iCommonsList.getSorted(Comparator.naturalOrder())) {
                LOGGER.info("  " + string);
            }
        }
    }

    protected final void logInitParameters(@Nonnull ServletContext servletContext) {
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        Enumeration<String> enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String object = servletContext.getInitParameter(string);
            commonsTreeMap.put(string, object);
        }
        if (commonsTreeMap.isEmpty()) {
            LOGGER.info("No servlet context init-parameters present");
        } else {
            LOGGER.info("Servlet context init-parameters:");
            for (Map.Entry entry : commonsTreeMap.entrySet()) {
                LOGGER.info("  " + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
    }

    protected final void logThirdpartyModules() {
        ICommonsOrderedSet<IThirdPartyModule> iCommonsOrderedSet = ThirdPartyModuleRegistry.getInstance().getAllRegisteredThirdPartyModules();
        if (!iCommonsOrderedSet.isEmpty()) {
            LOGGER.info("Using the following third party modules:");
            for (IThirdPartyModule iThirdPartyModule : iCommonsOrderedSet.getSorted(IHasDisplayName.getComparatorCollating(SystemHelper.getSystemLocale()))) {
                if (iThirdPartyModule.isOptional()) continue;
                String string = "  " + iThirdPartyModule.getDisplayName();
                if (iThirdPartyModule.getVersion() != null) {
                    string = string + ' ' + iThirdPartyModule.getVersion().getAsString(true);
                }
                string = string + " licensed under " + iThirdPartyModule.getLicense().getDisplayName();
                if (iThirdPartyModule.getLicense().getVersion() != null) {
                    string = string + ' ' + iThirdPartyModule.getLicense().getVersion().getAsString();
                }
                LOGGER.info(string);
            }
        }
    }

    protected final void logJMX() {
        if (SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote") != null) {
            String string = SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote.port");
            String string2 = SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote.ssl");
            String string3 = SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote.authenticate");
            String string4 = SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote.password.file");
            String string5 = SystemProperties.getPropertyValueOrNull("com.sun.management.jmxremote.access.file");
            LOGGER.info("Remote JMX is enabled!");
            if (string != null) {
                LOGGER.info("  Port=" + string);
            }
            if (string2 != null) {
                LOGGER.info("  SSL enabled=" + string2);
            }
            if (string3 != null) {
                LOGGER.info("  Authenticate=" + string3);
            }
            if (string4 != null) {
                LOGGER.info("  Password file=" + string4);
            }
            if (string5 != null) {
                LOGGER.info("  Access file=" + string5);
            }
        }
    }

    @OverrideOnDemand
    protected void logStartupInfo(@Nonnull ServletContext servletContext) {
        this.logLogo();
        this.logServerInfo(servletContext);
        this.logClassPath();
        this.logInitParameters(servletContext);
        this.logThirdpartyModules();
        this.logJMX();
    }

    @OverrideOnDemand
    protected void onTheVeryBeginning(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void beforeContextInitialized(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void afterContextInitialized(@Nonnull ServletContext servletContext) {
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterDebug(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(DEFAULT_INIT_PARAMETER_DEBUG);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterProduction(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(DEFAULT_INIT_PARAMETER_PRODUCTION);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterNoStartupInfo(@Nonnull ServletContext servletContext) {
        return servletContext.getInitParameter(INIT_PARAMETER_NO_STARTUP_INFO);
    }

    @Nullable
    @OverrideOnDemand
    protected String getInitParameterServerURL(@Nonnull ServletContext servletContext, boolean bl) {
        String string = bl ? INIT_PARAMETER_SERVER_URL_PRODUCTION : INIT_PARAMETER_SERVER_URL;
        return servletContext.getInitParameter(string);
    }

    @Nonnull
    @Nonempty
    protected String getServletContextPath(@Nonnull ServletContext servletContext) throws IllegalStateException {
        return ServletHelper.getServletContextBasePath(servletContext);
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getDataPath(@Nonnull ServletContext servletContext) {
        String string = servletContext.getInitParameter(INIT_PARAMETER_DATA_PATH);
        if (StringHelper.hasNoText(string) && StringHelper.hasText(string = servletContext.getInitParameter("storagePath"))) {
            LOGGER.error("You are using the old 'storagePath' parameter. Please use 'dataPath' instead!");
        }
        if (StringHelper.hasNoText(string)) {
            string = this.getServletContextPath(servletContext);
            if (GlobalDebug.isDebugMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("No servlet context init-parameter 'dataPath' found! Defaulting to servlet context path '" + string + "'");
            }
        }
        return string;
    }

    @OverrideOnDemand
    protected boolean shouldCheckFileAccess(@Nonnull ServletContext servletContext) {
        return !StringParser.parseBool(servletContext.getInitParameter(INIT_PARAMETER_NO_CHECK_FILE_ACCESS));
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void initPaths(@Nonnull ServletContext servletContext) {
        String string = this.getServletContextPath(servletContext);
        String string2 = this.getDataPath(servletContext);
        if (StringHelper.hasNoText(string2)) {
            throw new InitializationException("No data path was provided!");
        }
        File file = new File(string2).getAbsoluteFile();
        boolean bl = this.shouldCheckFileAccess(servletContext);
        WebFileIO.initPaths(file, string, bl);
    }

    @OverrideOnDemand
    protected void initGlobalIDFactory() {
        GlobalIDFactory.setPersistentLongIDFactory(new WebIOLongIDFactory(ID_FILENAME));
        GlobalIDFactory.setPersistentIntIDFactory(() -> (int)GlobalIDFactory.getNewPersistentLongID());
    }

    protected final void initDefaultGlobalSettings() {
        WebScopeManager.setSessionPassivationAllowed(false);
        GlobalPasswordSettings.setPasswordConstraintList(new PasswordConstraintList(new PasswordConstraintMinLength(6)));
        EmailGlobalSettings.addEmailDataTransportListener(new AuditingEmailDataTransportListener());
        if (GlobalDebug.isDebugMode()) {
            EmailGlobalSettings.addConnectionListener(new LoggingConnectionListener());
        } else {
            HCSettings.getMutableConversionSettings().setToOptimized();
            CSSValue.setConsistencyChecksEnabled(false);
        }
    }

    @OverrideOnDemand
    protected void initGlobalSettings() {
    }

    @OverrideOnDemand
    protected void initLocales(@Nonnull ILocaleManager iLocaleManager) {
    }

    @OverrideOnDemand
    protected void initMenu() {
    }

    @OverrideOnDemand
    protected void initAjax(@Nonnull IAjaxRegistry iAjaxRegistry) {
    }

    @OverrideOnDemand
    protected void initAPI(@Nonnull IAPIRegistry iAPIRegistry) {
    }

    @OverrideOnDemand
    protected void initSecurity() {
    }

    @OverrideOnDemand
    protected void initUI() {
    }

    @OverrideOnDemand
    protected void initManagers() {
    }

    @OverrideOnDemand
    protected void initJobs() {
    }

    @Override
    public final void contextInitialized(@Nonnull ServletContextEvent servletContextEvent) {
        String string;
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (WebAppListener.isOnlyOneInstanceAllowed() && s_aInited.getAndSet(true)) {
            throw new IllegalStateException("WebAppListener was already instantiated!");
        }
        StopWatch stopWatch = StopWatch.createdStarted();
        this.m_aInitializationStartDT = PDTFactory.getCurrentLocalDateTime();
        this.onTheVeryBeginning(servletContext);
        boolean bl = StringParser.parseBool(this.getInitParameterDebug(servletContext));
        boolean bl2 = StringParser.parseBool(this.getInitParameterProduction(servletContext));
        GlobalDebug.setDebugModeDirect(bl);
        GlobalDebug.setProductionModeDirect(bl2);
        boolean bl3 = StringParser.parseBool(this.getInitParameterNoStartupInfo(servletContext));
        if (!bl3) {
            this.logStartupInfo(servletContext);
        }
        if (StringHelper.hasText(string = this.getInitParameterServerURL(servletContext, bl2))) {
            URL uRL = URLHelper.getAsURL(string);
            if (uRL != null) {
                StaticServerInfo.init(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), servletContext.getContextPath());
            } else {
                LOGGER.error("The init-parameter for the server URL" + (bl2 ? " (production mode)" : " (non-production mode)") + "contains the non-URL value '" + string + "'");
            }
        }
        this.beforeContextInitialized(servletContext);
        if (WebAppListener.isOnlyOneInstanceAllowed() || !WebScopeManager.isGlobalScopePresent()) {
            WebScopeManager.onGlobalBegin(servletContext);
            PhotonCoreInit.startUp();
            this.initPaths(servletContext);
            this.initGlobalIDFactory();
            this.initDefaultGlobalSettings();
            this.initGlobalSettings();
            this.initLocales(GlobalLocaleManager.getInstance());
            this.initMenu();
            this.initAjax(GlobalAjaxInvoker.getInstance().getRegistry());
            this.initAPI(GlobalAPIInvoker.getInstance().getRegistry());
            this.initSecurity();
            this.initUI();
            this.initManagers();
            this.initJobs();
        }
        this.afterContextInitialized(servletContext);
        this.m_aInitializationEndDT = PDTFactory.getCurrentLocalDateTime();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' was initialized in " + stopWatch.stopAndGetMillis() + " milli seconds");
        }
    }

    @Nullable
    public final LocalDateTime getInitializationStartDT() {
        return this.m_aInitializationStartDT;
    }

    @Nullable
    public final LocalDateTime getInitializationEndDT() {
        return this.m_aInitializationEndDT;
    }

    @OverrideOnDemand
    protected void beforeContextDestroyed(@Nonnull ServletContext servletContext) {
    }

    @OverrideOnDemand
    protected void afterContextDestroyed(@Nonnull ServletContext servletContext) {
    }

    public final boolean isHandleStatisticsOnEnd() {
        return this.m_bHandleStatisticsOnEnd;
    }

    @Nonnull
    public final WebAppListener setHandleStatisticsOnEnd(boolean bl) {
        this.m_bHandleStatisticsOnEnd = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getStatisticsFilename() {
        return "statistics/" + PDTFactory.getCurrentYear() + "/statistics_" + PDTIOHelper.getCurrentLocalDateTimeForFilename() + ".xml";
    }

    @OverrideOnDemand
    protected void handleStatisticsOnEnd() {
        if (WebFileIO.isInited()) {
            try {
                IMicroDocument iMicroDocument = StatisticsExporter.getAsXMLDocument();
                iMicroDocument.getDocumentElement().setAttribute("location", "shutdown");
                iMicroDocument.getDocumentElement().setAttribute("datetime", PDTWebDateHelper.getAsStringXSD(PDTFactory.getCurrentLocalDateTime()));
                File file = WebFileIO.getDataIO().getFile(this.getStatisticsFilename());
                MicroWriter.writeToFile((IMicroNode)iMicroDocument, file);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to write statistics on context shutdown.", throwable);
            }
        } else {
            LOGGER.error("Not writing statistics because WebFileIO was not initialized!");
        }
    }

    @Override
    public final void contextDestroyed(@Nonnull ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        StopWatch stopWatch = StopWatch.createdStarted();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' is being destroyed");
        }
        this.beforeContextDestroyed(servletContext);
        WebScopeManager.onGlobalEnd();
        this.afterContextDestroyed(servletContext);
        if (this.isHandleStatisticsOnEnd()) {
            this.handleStatisticsOnEnd();
        }
        PhotonCoreInit.shutdown();
        if (WebAppListener.isOnlyOneInstanceAllowed()) {
            s_aInited.set(false);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Servlet context '" + servletContext.getServletContextName() + "' was destroyed in " + stopWatch.stopAndGetMillis() + " milli seconds");
        }
    }

    @Override
    public final void sessionCreated(@Nonnull HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        WebScopeManager.onSessionBegin(httpSession);
    }

    @Override
    public final void sessionDestroyed(@Nonnull HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        WebScopeManager.onSessionEnd(httpSession);
    }

    static {
        SystemProperties.setPropertyValue("java.awt.headless", "true");
        LOGGER = LoggerFactory.getLogger(WebAppListener.class);
        s_aOnlyOneInstanceAllowed = new AtomicBoolean(true);
        s_aInited = new AtomicBoolean(false);
    }
}

