/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.audit.AuditHelper;
import com.helger.smtp.listener.EmailDataTransportEvent;
import com.helger.smtp.listener.IEmailDataTransportListener;
import com.helger.smtp.transport.listener.LoggingTransportListener;
import javax.annotation.Nonnull;

public class AuditingEmailDataTransportListener
implements IEmailDataTransportListener {
    @Override
    public void messageDelivered(@Nonnull EmailDataTransportEvent emailDataTransportEvent) {
        AuditHelper.onAuditExecuteSuccess("email-message-delivered", emailDataTransportEvent.getEmailData().getSubject(), emailDataTransportEvent.getValidSentAddresses(), emailDataTransportEvent.getValidUnsentAddresses(), emailDataTransportEvent.getInvalidAddresses(), LoggingTransportListener.getMessageString(emailDataTransportEvent.getMimeMessage()));
    }

    @Override
    public void messageNotDelivered(@Nonnull EmailDataTransportEvent emailDataTransportEvent) {
        AuditHelper.onAuditExecuteFailure("email-message-delivered", "not-delivered", emailDataTransportEvent.getEmailData().getSubject(), emailDataTransportEvent.getValidSentAddresses(), emailDataTransportEvent.getValidUnsentAddresses(), emailDataTransportEvent.getInvalidAddresses(), LoggingTransportListener.getMessageString(emailDataTransportEvent.getMimeMessage()));
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

