/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.state.EChange;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FailedMailQueueWithDAO
extends FailedMailQueue {
    private static final long serialVersionUID = -4807647156903750122L;
    private transient FMQDAO m_aDAO;

    public FailedMailQueueWithDAO(@Nullable String string) {
        try {
            this.m_aDAO = new FMQDAO(string);
            this.m_aDAO.myInitialRead();
        }
        catch (DAOException dAOException) {
            throw new InitializationException("Failed to init FailedMailQueueWithDAO with filename '" + string + "'", dAOException);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF((String)this.m_aDAO.getFilenameProvider().get());
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = objectInputStream.readUTF();
        try {
            this.m_aDAO = new FMQDAO(string);
            this.m_aDAO.myInitialRead();
        }
        catch (DAOException dAOException) {
            throw new InitializationException("Failed to init FailedMailQueueWithDAO with filename '" + string + "'", dAOException);
        }
    }

    private void _markAsChanged() {
        this.m_aRWLock.writeLocked(() -> this.m_aDAO.myMarkChanged());
    }

    @Override
    public void add(@Nonnull FailedMailData failedMailData) {
        this.add(failedMailData, true);
    }

    public void add(@Nonnull FailedMailData failedMailData, boolean bl) {
        super.add(failedMailData);
        this._markAsChanged();
        if (bl) {
            AuditHelper.onAuditExecuteSuccess("failedmail-add", failedMailData);
        }
    }

    @Override
    @Nullable
    public FailedMailData remove(@Nullable String string) {
        FailedMailData failedMailData = super.remove(string);
        if (failedMailData != null) {
            this._markAsChanged();
            AuditHelper.onAuditExecuteSuccess("failedmail-remove", string);
        } else {
            AuditHelper.onAuditExecuteFailure("failedmail-remove", string);
        }
        return failedMailData;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<FailedMailData> removeAll() {
        ICommonsList<FailedMailData> iCommonsList = super.removeAll();
        if (!iCommonsList.isEmpty()) {
            this._markAsChanged();
            AuditHelper.onAuditExecuteSuccess("failedmail-remove-all", iCommonsList.size());
        }
        return iCommonsList;
    }

    private final class FMQDAO
    extends AbstractPhotonSimpleDAO {
        private static final String ELEMENT_FAILEDMAILS = "failedmails";
        private static final String ELEMENT_FAILEDMAILDATA = "failedmaildata";

        public FMQDAO(String string) {
            super(string);
        }

        @MustBeLocked(value=ELockType.WRITE)
        protected void myInitialRead() throws DAOException {
            this.initialRead();
        }

        @MustBeLocked(value=ELockType.WRITE)
        protected void myMarkChanged() {
            super.markAsChanged();
        }

        @Override
        @Nonnull
        protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_FAILEDMAILDATA)) {
                FailedMailData failedMailData = MicroTypeConverter.convertToNative(iMicroElement, FailedMailData.class);
                if (failedMailData == null) continue;
                FailedMailQueueWithDAO.this.add(failedMailData, false);
            }
            return EChange.UNCHANGED;
        }

        @Override
        @Nonnull
        protected IMicroDocument createWriteData() {
            MicroDocument microDocument = new MicroDocument();
            IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_FAILEDMAILS);
            for (FailedMailData failedMailData : FailedMailQueueWithDAO.this.getAllFailedMails()) {
                iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(failedMailData, ELEMENT_FAILEDMAILDATA));
            }
            return microDocument;
        }
    }
}

