/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ITypedObject;
import com.helger.commons.type.ObjectType;
import com.helger.smtp.settings.ISMTPSettings;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class NamedSMTPSettings
implements ITypedObject<String>,
Serializable {
    public static final ObjectType OT = new ObjectType("named-smtp-settings");
    private final String m_sID;
    private String m_sName;
    private ISMTPSettings m_aSMTPSettings;

    public NamedSMTPSettings(@Nonnull @Nonempty String string, @Nonnull ISMTPSettings iSMTPSettings) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, iSMTPSettings);
    }

    NamedSMTPSettings(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notEmpty(string, "ID");
        this.m_sID = string;
        this.setName(string2);
        this.setSMTPSettings(iSMTPSettings);
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    public EChange setSMTPSettings(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull(iSMTPSettings, "SMTPSettings");
        if (iSMTPSettings.equals(this.m_aSMTPSettings)) {
            return EChange.UNCHANGED;
        }
        this.m_aSMTPSettings = iSMTPSettings;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        NamedSMTPSettings namedSMTPSettings = (NamedSMTPSettings)object;
        return this.m_sID.equals(namedSMTPSettings.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("name", this.m_sName).append("SMTPsettings", this.m_aSMTPSettings).getToString();
    }
}

