/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.smtp;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.smtp.NamedSMTPSettings;
import com.helger.smtp.CSMTP;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NamedSMTPSettingsManager
extends AbstractPhotonSimpleDAO
implements IHasSize {
    private static final String ELEMENT_ROOT = "namedsmtpsettingslist";
    private static final String ELEMENT_ITEM = "namedsmtpsettings";
    private static boolean s_bCreateDefaults = true;
    private final ICommonsMap<String, NamedSMTPSettings> m_aMap = new CommonsHashMap<String, NamedSMTPSettings>();

    public static boolean isCreateDefaults() {
        return s_aRWLock.readLockedBoolean(() -> s_bCreateDefaults);
    }

    public static void setCreateDefaults(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bCreateDefaults = bl;
            return s_bCreateDefaults;
        });
    }

    public NamedSMTPSettingsManager(@Nonnull @Nonempty String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Override
    public boolean isReloadable() {
        return true;
    }

    @Override
    public void reload() throws DAOException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aMap.clear();
            this.initialRead();
        });
    }

    @Override
    @Nonnull
    protected EChange onInit() {
        if (!NamedSMTPSettingsManager.isCreateDefaults()) {
            return EChange.UNCHANGED;
        }
        this._addItem(new NamedSMTPSettings("default", "default", new SMTPSettings("localhost", 25, null, null, CSMTP.CHARSET_SMTP_OBJ, false)));
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_ITEM)) {
            this._addItem(MicroTypeConverter.convertToNative(iMicroElement, NamedSMTPSettings.class));
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_ROOT);
        for (NamedSMTPSettings namedSMTPSettings : CollectionHelper.getSortedByKey(this.m_aMap).values()) {
            iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(namedSMTPSettings, ELEMENT_ITEM));
        }
        return microDocument;
    }

    private void _addItem(@Nonnull NamedSMTPSettings namedSMTPSettings) {
        String string = namedSMTPSettings.getID();
        if (this.m_aMap.containsKey(string)) {
            throw new IllegalArgumentException("NamedSMTPSettings ID " + string + " is already in use!");
        }
        this.m_aMap.put(string, namedSMTPSettings);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aMap::isEmpty);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, NamedSMTPSettings> getAllSettings() {
        return this.m_aRWLock.readLockedGet(this.m_aMap::getClone);
    }

    public boolean containsSettings(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.containsKey(string));
    }

    @Nullable
    public NamedSMTPSettings getSettings(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (NamedSMTPSettings)this.m_aMap.get(string));
    }

    @Nullable
    public NamedSMTPSettings getDefaultSettings() {
        return this.getSettings("default");
    }

    @Nullable
    public ISMTPSettings getDefaultSMTPSettings() {
        NamedSMTPSettings namedSMTPSettings = this.getDefaultSettings();
        return namedSMTPSettings == null ? null : namedSMTPSettings.getSMTPSettings();
    }

    @Nullable
    public NamedSMTPSettings getSettingsOfName(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> CollectionHelper.findFirst(this.m_aMap.values(), namedSMTPSettings -> namedSMTPSettings.getName().equals(string)));
    }

    @Nonnull
    public NamedSMTPSettings addSettings(@Nonnull @Nonempty String string, @Nonnull ISMTPSettings iSMTPSettings) {
        NamedSMTPSettings namedSMTPSettings = new NamedSMTPSettings(string, iSMTPSettings);
        this.m_aRWLock.writeLocked(() -> {
            this._addItem(namedSMTPSettings);
            this.markAsChanged();
        });
        AuditHelper.onAuditCreateSuccess(NamedSMTPSettings.OT, namedSMTPSettings.getID(), namedSMTPSettings.getName(), iSMTPSettings.getHostName(), iSMTPSettings.getPort(), iSMTPSettings.getCharsetName(), iSMTPSettings.isSSLEnabled(), iSMTPSettings.isSTARTTLSEnabled(), iSMTPSettings.getConnectionTimeoutMilliSecs(), iSMTPSettings.getTimeoutMilliSecs());
        return namedSMTPSettings;
    }

    @Nullable
    public EChange updateSettings(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull ISMTPSettings iSMTPSettings) {
        NamedSMTPSettings namedSMTPSettings = this.getSettings(string);
        if (namedSMTPSettings == null) {
            AuditHelper.onAuditModifyFailure(NamedSMTPSettings.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(namedSMTPSettings.setName(string2));
            if ((eChange = eChange.or(namedSMTPSettings.setSMTPSettings(iSMTPSettings))).isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            AuditHelper.onAuditModifySuccess(NamedSMTPSettings.OT, namedSMTPSettings.getID(), namedSMTPSettings.getName(), iSMTPSettings.getHostName(), iSMTPSettings.getPort(), iSMTPSettings.getCharsetName(), iSMTPSettings.isSSLEnabled(), iSMTPSettings.isSTARTTLSEnabled(), iSMTPSettings.getConnectionTimeoutMilliSecs(), iSMTPSettings.getTimeoutMilliSecs());
            return EChange.CHANGED;
        });
    }

    @Nullable
    public EChange removeSettings(@Nullable String string) {
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.valueOf(this.m_aMap.remove(string) != null);
            if (eChange.isChanged()) {
                this.markAsChanged();
                AuditHelper.onAuditDeleteSuccess(NamedSMTPSettings.OT, string);
            } else {
                AuditHelper.onAuditDeleteFailure(NamedSMTPSettings.OT, string, "no-such-id");
            }
            return eChange;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeAllSettings() {
        ICommonsSet iCommonsSet = this.m_aRWLock.readLockedGet(this.m_aMap::copyOfKeySet);
        EChange eChange = EChange.UNCHANGED;
        this.beginWithoutAutoSave();
        try {
            for (String string : iCommonsSet) {
                eChange = eChange.or(this.removeSettings(string));
            }
        }
        finally {
            this.endWithoutAutoSave();
        }
        return eChange;
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

