/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.collection.multimap.IMultiMapListBased;
import com.helger.collection.multimap.MultiHashMapArrayListBased;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.commons.state.SuccessWithValue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.sysmigration.SystemMigrationResult;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SystemMigrationManager
extends AbstractPhotonSimpleDAO {
    public static final ObjectType OT_SYSTEM_MIGRATION_RESULT = new ObjectType("systemmigrationresult");
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMigrationManager.class);
    private static final String ELEMENT_SYSTEM_MIGRATION_RESULTS = "systemmigrationresults";
    private static final String ELEMENT_SYSTEM_MIGRATION_RESULT = "systemmigrationresult";
    private final IMultiMapListBased<String, SystemMigrationResult> m_aMap = new MultiHashMapArrayListBased<String, SystemMigrationResult>();

    public SystemMigrationManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Override
    protected EChange onRead(IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_SYSTEM_MIGRATION_RESULT)) {
            this.internalAdd(MicroTypeConverter.convertToNative(iMicroElement, SystemMigrationResult.class));
        }
        return EChange.UNCHANGED;
    }

    @Override
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_SYSTEM_MIGRATION_RESULTS);
        for (List list : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            for (SystemMigrationResult systemMigrationResult : list) {
                iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(systemMigrationResult, ELEMENT_SYSTEM_MIGRATION_RESULT));
            }
        }
        return microDocument;
    }

    void internalAdd(@Nonnull SystemMigrationResult systemMigrationResult) {
        ValueEnforcer.notNull(systemMigrationResult, "MigrationResult");
        String string = systemMigrationResult.getID();
        this.m_aMap.putSingle(string, systemMigrationResult);
    }

    public void addMigrationResult(@Nonnull SystemMigrationResult systemMigrationResult) {
        ValueEnforcer.notNull(systemMigrationResult, "MigrationResult");
        this.m_aRWLock.writeLocked(() -> {
            this.internalAdd(systemMigrationResult);
            this.markAsChanged();
        });
        AuditHelper.onAuditCreateSuccess(OT_SYSTEM_MIGRATION_RESULT, systemMigrationResult.getID(), systemMigrationResult.isSuccess(), systemMigrationResult.getErrorMessage());
    }

    public void addMigrationResultSuccess(@Nonnull @Nonempty String string) {
        this.addMigrationResult(SystemMigrationResult.createSuccess(string));
    }

    public void addMigrationResultError(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this.addMigrationResult(SystemMigrationResult.createFailure(string, string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllMigrationResults(@Nullable String string) {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList<Collection>((Collection)this.m_aMap.get(string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllMigrationResultsFlattened() {
        CommonsArrayList<SystemMigrationResult> commonsArrayList = new CommonsArrayList<SystemMigrationResult>();
        this.m_aRWLock.readLocked(() -> {
            for (ICommonsList iCommonsList2 : this.m_aMap.values()) {
                commonsArrayList.addAll(iCommonsList2);
            }
        });
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<SystemMigrationResult> getAllFailedMigrationResults(@Nullable String string) {
        return this.getAllMigrationResults(string).getAll(SystemMigrationResult::isFailure);
    }

    public boolean wasMigrationExecutedSuccessfully(@Nullable String string) {
        return this.getAllMigrationResults(string).containsAny(SystemMigrationResult::isSuccess);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllMigrationIDs() {
        return this.m_aRWLock.readLockedGet(this.m_aMap::copyOfKeySet);
    }

    public void performMigrationIfNecessary(@Nonnull @Nonempty String string, @Nonnull Runnable runnable) {
        ValueEnforcer.notEmpty(string, "MigrationID");
        ValueEnforcer.notNull(runnable, "MigrationAction");
        if (!this.wasMigrationExecutedSuccessfully(string)) {
            try {
                LOGGER.info("Performing migration '" + string + "'");
                runnable.run();
                LOGGER.info("Finished performing migration '" + string + "'");
                this.addMigrationResultSuccess(string);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error execution system migration '" + string + "'", runtimeException);
                this.addMigrationResultError(string, runtimeException.getClass() + ": " + runtimeException.getMessage());
            }
        }
    }

    public void performMigrationIfNecessary(@Nonnull @Nonempty String string, @Nonnull Supplier<SuccessWithValue<String>> supplier) {
        ValueEnforcer.notEmpty(string, "MigrationID");
        ValueEnforcer.notNull(supplier, "MigrationAction");
        if (!this.wasMigrationExecutedSuccessfully(string)) {
            try {
                LOGGER.info("Performing migration '" + string + "'");
                SuccessWithValue<String> successWithValue = supplier.get();
                LOGGER.info("Finished performing migration '" + string + "' with status " + (successWithValue.isSuccess() ? "success" : "error"));
                if (successWithValue.isSuccess()) {
                    this.addMigrationResultSuccess(string);
                } else {
                    this.addMigrationResultError(string, successWithValue.get());
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error execution system migration '" + string + "'", runtimeException);
                this.addMigrationResultError(string, runtimeException.getClass() + ": " + runtimeException.getMessage());
            }
        }
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

