/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SystemMigrationResult
implements IHasID<String>,
ISuccessIndicator,
Serializable {
    private final String m_sMigrationID;
    private final LocalDateTime m_aExecutionDT;
    private final boolean m_bSuccess;
    private final String m_sErrorMessage;

    protected SystemMigrationResult(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, boolean bl, @Nullable String string2) {
        this.m_sMigrationID = ValueEnforcer.notEmpty(string, "MigrationID");
        this.m_aExecutionDT = ValueEnforcer.notNull(localDateTime, "ExecutionDT");
        this.m_bSuccess = bl;
        this.m_sErrorMessage = string2;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sMigrationID;
    }

    @Nonnull
    public LocalDateTime getExecutionDateTime() {
        return this.m_aExecutionDT;
    }

    @Override
    public boolean isSuccess() {
        return this.m_bSuccess;
    }

    @Override
    public boolean isFailure() {
        return !this.m_bSuccess;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public boolean hasErrorMessage() {
        return StringHelper.hasText(this.m_sErrorMessage);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SystemMigrationResult systemMigrationResult = (SystemMigrationResult)object;
        return this.m_sMigrationID.equals(systemMigrationResult.m_sMigrationID) && this.m_aExecutionDT.equals(systemMigrationResult.m_aExecutionDT) && this.m_bSuccess == systemMigrationResult.m_bSuccess && EqualsHelper.equals(this.m_sErrorMessage, systemMigrationResult.m_sErrorMessage);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sMigrationID).append(this.m_aExecutionDT).append(this.m_bSuccess).append(this.m_sErrorMessage).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sMigrationID).append("executionDT", this.m_aExecutionDT).append("success", this.m_bSuccess).append("errorMsg", this.m_sErrorMessage).getToString();
    }

    @Nonnull
    public static SystemMigrationResult createSuccess(@Nonnull @Nonempty String string) {
        return new SystemMigrationResult(string, PDTFactory.getCurrentLocalDateTime(), true, null);
    }

    @Nonnull
    public static SystemMigrationResult createFailure(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return new SystemMigrationResult(string, PDTFactory.getCurrentLocalDateTime(), false, string2);
    }
}

