/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.sysmigration;

import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringParser;
import com.helger.photon.core.sysmigration.SystemMigrationResult;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SystemMigrationResultMicroTypeConverter
implements IMicroTypeConverter<SystemMigrationResult> {
    private static final String ATTR_MIGRATION_ID = "id";
    private static final String ATTR_EXECUTION_LDT = "executionldt";
    private static final String ATTR_SUCCESS = "success";
    private static final String ELEMENT_ERROR_MSG = "errormsg";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull SystemMigrationResult systemMigrationResult, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_MIGRATION_ID, systemMigrationResult.getID());
        microElement.setAttributeWithConversion(ATTR_EXECUTION_LDT, (Object)systemMigrationResult.getExecutionDateTime());
        microElement.setAttribute(ATTR_SUCCESS, systemMigrationResult.isSuccess());
        if (systemMigrationResult.hasErrorMessage()) {
            microElement.appendElement(string, ELEMENT_ERROR_MSG).appendText(systemMigrationResult.getErrorMessage());
        }
        return microElement;
    }

    @Override
    @Nonnull
    @ContainsSoftMigration
    public SystemMigrationResult convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object;
        String string = iMicroElement.getAttributeValue(ATTR_MIGRATION_ID);
        LocalDateTime localDateTime = iMicroElement.getAttributeValueWithConversion(ATTR_EXECUTION_LDT, LocalDateTime.class);
        if (localDateTime == null) {
            object = iMicroElement.getAttributeValueWithConversion("executiondt", ZonedDateTime.class);
            if (object != null) {
                localDateTime = ((ZonedDateTime)object).toLocalDateTime();
            } else {
                throw new IllegalStateException("No exceution date time found!");
            }
        }
        object = iMicroElement.getAttributeValue(ATTR_SUCCESS);
        boolean bl = StringParser.parseBool((String)object);
        String string2 = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_ERROR_MSG);
        return new SystemMigrationResult(string, localDateTime, bl, string2);
    }
}

