/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.systemmsg;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.photon.core.EPhotonCoreText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESystemMessageType implements IHasID<String>,
IHasDisplayText
{
    INFO("i", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_INFO),
    WARNING("w", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_WARNING),
    ERROR("e", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_ERROR),
    SUCCESS("s", EPhotonCoreText.SYSTEM_MESSAGE_TYPE_SUCCESS);

    public static final ESystemMessageType DEFAULT;
    private final String m_sID;
    private final EPhotonCoreText m_eText;

    private ESystemMessageType(String string2, EPhotonCoreText ePhotonCoreText) {
        this.m_sID = string2;
        this.m_eText = ePhotonCoreText;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_eText.getDisplayText(locale);
    }

    @Nonnull
    public static ESystemMessageType getFromIDOrDefault(@Nullable String string) {
        return EnumHelper.getFromIDOrDefault(ESystemMessageType.class, string, DEFAULT);
    }

    static {
        DEFAULT = INFO;
    }
}

