/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.systemmsg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.ISystemMessageData;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SystemMessageData
implements ISystemMessageData {
    private LocalDateTime m_aLastUpdate;
    private ESystemMessageType m_eMessageType = ESystemMessageType.DEFAULT;
    private String m_sMessage;

    public SystemMessageData() {
    }

    public SystemMessageData(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        this.internalSetMessageType(eSystemMessageType);
        this.internalSetMessage(string);
    }

    @Override
    @Nullable
    public LocalDateTime getLastUpdateDT() {
        return this.m_aLastUpdate;
    }

    @Override
    @Nonnull
    public ESystemMessageType getMessageType() {
        return this.m_eMessageType;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.m_sMessage;
    }

    final void internalReset() {
        this.setLastUpdate(null);
        this.internalSetMessageType(ESystemMessageType.DEFAULT);
        this.internalSetMessage(null);
    }

    public final void setLastUpdate(@Nullable LocalDateTime localDateTime) {
        this.m_aLastUpdate = localDateTime;
    }

    final void internalSetMessageType(@Nonnull ESystemMessageType eSystemMessageType) {
        ValueEnforcer.notNull(eSystemMessageType, "Type");
        this.m_eMessageType = eSystemMessageType;
    }

    final void internalSetMessage(@Nullable String string) {
        this.m_sMessage = string;
    }

    @Nonnull
    public EChange setSystemMessage(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        ValueEnforcer.notNull(eSystemMessageType, "MessageType");
        if (this.m_eMessageType.equals(eSystemMessageType) && EqualsHelper.equals(this.m_sMessage, string)) {
            return EChange.UNCHANGED;
        }
        this.internalSetMessageType(eSystemMessageType);
        this.internalSetMessage(string);
        this.setLastUpdate(PDTFactory.getCurrentLocalDateTime());
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SystemMessageData systemMessageData = (SystemMessageData)object;
        return EqualsHelper.equals(this.m_aLastUpdate, systemMessageData.m_aLastUpdate) && this.m_eMessageType.equals(systemMessageData.m_eMessageType) && EqualsHelper.equals(this.m_sMessage, systemMessageData.m_sMessage);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aLastUpdate).append((Enum)this.m_eMessageType)).append(this.m_sMessage).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("LastUpdate", this.m_aLastUpdate).append("MessageType", this.m_eMessageType).append("Message", this.m_sMessage).getToString();
    }
}

