/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.systemmsg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.SystemMessageData;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemMessageManager
extends AbstractPhotonSimpleDAO {
    private static final String ELEMENT_SYSTEM_MESSAGE = "systemmessage";
    private static final String ATTR_LAST_UPDATE = "lastupdate";
    private static final String ATTR_MESSAGE_TYPE = "messagetype";
    private static final String ELEMENT_MESSAGE = "message";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMessageManager.class);
    private final SystemMessageData m_aData = new SystemMessageData();

    public SystemMessageManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Override
    public boolean isReloadable() {
        return true;
    }

    @Override
    public void reload() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aData.internalReset();
            try {
                this.initialRead();
            }
            catch (DAOException dAOException) {
                throw new IllegalStateException("Failed to reload system message", dAOException);
            }
        });
        LOGGER.info("Reloaded system message!");
    }

    @Override
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        this.m_aData.setLastUpdate(iMicroElement.getAttributeValueWithConversion(ATTR_LAST_UPDATE, LocalDateTime.class));
        this.m_aData.internalSetMessageType(ESystemMessageType.getFromIDOrDefault(iMicroElement.getAttributeValue(ATTR_MESSAGE_TYPE)));
        this.m_aData.internalSetMessage(MicroHelper.getChildTextContent(iMicroElement, ELEMENT_MESSAGE));
        return EChange.UNCHANGED;
    }

    @Override
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_SYSTEM_MESSAGE);
        iMicroElement.setAttributeWithConversion(ATTR_LAST_UPDATE, (Object)this.m_aData.getLastUpdateDT());
        iMicroElement.setAttribute(ATTR_MESSAGE_TYPE, this.m_aData.getMessageTypeID());
        iMicroElement.appendElement(ELEMENT_MESSAGE).appendText(this.m_aData.getMessage());
        return microDocument;
    }

    @Nullable
    public LocalDateTime getLastUpdateDT() {
        return this.m_aRWLock.readLockedGet(this.m_aData::getLastUpdateDT);
    }

    @Nonnull
    public ESystemMessageType getMessageType() {
        return this.m_aRWLock.readLockedGet(this.m_aData::getMessageType);
    }

    @Nullable
    public String getSystemMessage() {
        return this.m_aRWLock.readLockedGet(this.m_aData::getMessage);
    }

    public boolean hasSystemMessage() {
        return this.m_aRWLock.readLockedBoolean(this.m_aData::hasMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange setSystemMessage(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        ValueEnforcer.notNull(eSystemMessageType, "MessageType");
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aData.setSystemMessage(eSystemMessageType, string).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.markAsChanged();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditExecuteSuccess("update-system-message", eSystemMessageType, string);
        return EChange.CHANGED;
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("Data", this.m_aData).getToString();
    }
}

