/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.uistate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.photon.core.uistate.IHasUIState;
import com.helger.photon.core.uistate.UIStateWrapper;
import com.helger.scope.IScopeRenewalAware;
import com.helger.web.scope.session.ISessionWebScopeDontPassivate;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UIStateRegistry
extends AbstractSessionWebSingleton
implements IScopeRenewalAware,
ISessionWebScopeDontPassivate {
    public static final ObjectType OT_HCNODE = new ObjectType("hcnode");
    private static final Logger LOGGER = LoggerFactory.getLogger(UIStateRegistry.class);
    private final ICommonsMap<ObjectType, ICommonsMap<String, IHasUIState>> m_aMap = new CommonsHashMap<ObjectType, ICommonsMap<String, IHasUIState>>();

    @Deprecated
    @UsedViaReflection
    public UIStateRegistry() {
    }

    @Nonnull
    public static UIStateRegistry getCurrent() {
        return UIStateRegistry.getSessionSingleton(UIStateRegistry.class);
    }

    @Nullable
    public IHasUIState getState(@Nullable ObjectType objectType, @Nullable String string) {
        if (objectType == null) {
            return null;
        }
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> {
            IHasUIState iHasUIState = null;
            Map map = (Map)this.m_aMap.get(objectType);
            if (map != null && (iHasUIState = (IHasUIState)map.get(string)) == null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!RegExHelper.stringMatchesPattern((String)entry.getKey(), string)) continue;
                    iHasUIState = (IHasUIState)entry.getValue();
                    break;
                }
            }
            return iHasUIState;
        });
    }

    @Nullable
    public <T> T getCastedState(@Nullable ObjectType objectType, @Nullable String string) {
        IHasUIState iHasUIState = this.getState(objectType, string);
        if (iHasUIState == null) {
            return null;
        }
        if (iHasUIState instanceof UIStateWrapper) {
            return (T)((UIStateWrapper)iHasUIState).getCastedObject();
        }
        return (T)GenericReflection.uncheckedCast(iHasUIState);
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public EChange registerState(@Nonnull @Nonempty String string, @Nonnull IHasUIState iHasUIState) {
        ValueEnforcer.notEmpty(string, "StateID");
        ValueEnforcer.notNull(iHasUIState, "NewState");
        ObjectType objectType = iHasUIState.getObjectType();
        if (objectType == null) {
            throw new IllegalStateException("Object has no typeID: " + iHasUIState);
        }
        return this.m_aRWLock.writeLockedGet(() -> {
            Map map = this.m_aMap.computeIfAbsent(objectType, objectType -> new CommonsHashMap());
            if (LOGGER.isDebugEnabled() && map.containsKey(string)) {
                LOGGER.debug("Overwriting " + objectType.getName() + " with ID " + string + " with new object");
            }
            map.put(string, iHasUIState);
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange registerState(@Nonnull IHCElement<?> iHCElement) {
        ValueEnforcer.notNull(iHCElement, "NewElement");
        if (iHCElement.hasNoID()) {
            LOGGER.warn("Registering the state for an object that has no ID - creating a new ID now!");
        }
        return this.registerState(((IHCElement)iHCElement.ensureID()).getID(), iHCElement);
    }

    @Nonnull
    public EChange registerState(@Nonnull @Nonempty String string, @Nonnull IHCNode iHCNode) {
        ValueEnforcer.notNull(iHCNode, "NewNode");
        return this.registerState(string, UIStateWrapper.create(OT_HCNODE, iHCNode));
    }

    @Nonnull
    public EChange removeState(@Nullable ObjectType objectType, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "StateID");
        return this.m_aRWLock.writeLockedGet(() -> {
            ICommonsMap iCommonsMap = (ICommonsMap)this.m_aMap.get(objectType);
            if (iCommonsMap == null) {
                return EChange.UNCHANGED;
            }
            return iCommonsMap.removeObject(string);
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UIStateRegistry uIStateRegistry = (UIStateRegistry)object;
        return this.m_aMap.equals(uIStateRegistry.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMap)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("map", this.m_aMap).getToString();
    }
}

