/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.uistate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.IHasObjectType;
import com.helger.commons.type.ObjectType;
import com.helger.photon.core.uistate.IHasUIState;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UIStateWrapper<T extends Serializable>
implements IHasUIState {
    private final ObjectType m_aObjectType;
    private final T m_aObject;

    public UIStateWrapper(@Nonnull ObjectType objectType, @Nonnull T t) {
        ValueEnforcer.notNull(objectType, "ObjectType");
        ValueEnforcer.notNull(t, "Object");
        this.m_aObjectType = objectType;
        this.m_aObject = t;
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return this.m_aObjectType;
    }

    @Nonnull
    public T getObject() {
        return this.m_aObject;
    }

    @Nullable
    public <U> U getCastedObject() {
        return (U)GenericReflection.uncheckedCast(this.m_aObject);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UIStateWrapper uIStateWrapper = (UIStateWrapper)object;
        return this.m_aObjectType.equals(uIStateWrapper.m_aObjectType) && EqualsHelper.equals(this.m_aObject, uIStateWrapper.m_aObject);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aObjectType).append(this.m_aObject).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("objectType", this.m_aObjectType).append("object", this.m_aObject).getToString();
    }

    @Nonnull
    public static <T extends Serializable> UIStateWrapper<T> create(@Nonnull ObjectType objectType, @Nonnull T t) {
        return new UIStateWrapper<T>(objectType, t);
    }

    @Nonnull
    public static <T extends Serializable & IHasObjectType> UIStateWrapper<T> create(@Nonnull T t) {
        return new UIStateWrapper<T>(((IHasObjectType)t).getObjectType(), t);
    }
}

