/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.userdata.IUserDataObject;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractUserDataObject
implements IUserDataObject {
    private final String m_sPath;
    private final boolean m_bIsTemporary;

    public AbstractUserDataObject(@Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notEmpty(string, "Path");
        this.m_sPath = FilenameHelper.getPathUsingUnixSeparator(FilenameHelper.ensurePathStartingWithSeparator(string));
        this.m_bIsTemporary = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    public boolean isTemporary() {
        return this.m_bIsTemporary;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractUserDataObject abstractUserDataObject = (AbstractUserDataObject)object;
        return this.m_sPath.equals(abstractUserDataObject.m_sPath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("path", this.m_sPath).append("isTemporary", this.m_bIsTemporary).getToString();
    }
}

