/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.url.LinkHelper;
import com.helger.photon.core.userdata.IUserDataObject;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.io.File;
import javax.annotation.Nonnull;

public final class UserDataManager {
    public static final String DEFAULT_USER_DATA_PATH = "/user";
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static String s_sUserDataPath = "/user";

    private UserDataManager() {
    }

    public static void setUserDataPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.isTrue(StringHelper.getLength(string) >= 2, "userDataPath is too short");
        ValueEnforcer.isTrue(StringHelper.startsWith((CharSequence)string, '/'), "userDataPath must start with a slash");
        s_aRWLock.writeLockedGet(() -> {
            s_sUserDataPath = string;
            return s_sUserDataPath;
        });
    }

    @Nonnull
    @Nonempty
    public static String getUserDataPath() {
        return s_aRWLock.readLockedGet(() -> s_sUserDataPath);
    }

    @Nonnull
    @Nonempty
    public static String getContextAndUserDataPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return LinkHelper.getURIWithContext(iRequestWebScopeWithoutResponse, UserDataManager.getUserDataPath());
    }

    @Nonnull
    @Nonempty
    public static String getURLPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull(iUserDataObject, "UDO");
        return LinkHelper.getURIWithContext(iRequestWebScopeWithoutResponse, UserDataManager.getUserDataPath() + iUserDataObject.getPath());
    }

    @Nonnull
    @Nonempty
    public static SimpleURL getURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IUserDataObject iUserDataObject) {
        return new SimpleURL(UserDataManager.getURLPath(iRequestWebScopeWithoutResponse, iUserDataObject));
    }

    @Nonnull
    private static IFileRelativeIO _getFileIO() {
        return WebFileIO.getDataIO();
    }

    @Nonnull
    public static File getBasePathFile() {
        return UserDataManager._getFileIO().getBasePathFile();
    }

    @Nonnull
    public static FileSystemResource getResource(@Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull(iUserDataObject, "UDO");
        return UserDataManager._getFileIO().getResource(UserDataManager.getUserDataPath() + iUserDataObject.getPath());
    }

    @Nonnull
    public static File getFile(@Nonnull IUserDataObject iUserDataObject) {
        ValueEnforcer.notNull(iUserDataObject, "UDO");
        return UserDataManager._getFileIO().getFile(UserDataManager.getUserDataPath() + iUserDataObject.getPath());
    }
}

