/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.userdata.TemporaryUserDataObject;
import com.helger.photon.core.userdata.UserDataObject;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UserUploadManager
extends AbstractSessionWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserUploadManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, TemporaryUserDataObject> m_aMap = new CommonsHashMap<String, TemporaryUserDataObject>();

    @Deprecated
    @UsedViaReflection
    public UserUploadManager() {
    }

    @Nonnull
    public static UserUploadManager getInstance() {
        return UserUploadManager.getSessionSingleton(UserUploadManager.class);
    }

    @Nonnull
    private static FileIOError _deleteUDO(@Nonnull TemporaryUserDataObject temporaryUserDataObject) {
        LOGGER.info("Deleting uploaded file " + temporaryUserDataObject);
        FileIOError fileIOError = FileOperationManager.INSTANCE.deleteFile(temporaryUserDataObject.getAsFile());
        if (fileIOError.isFailure()) {
            LOGGER.error("Failed to delete UDO " + temporaryUserDataObject.getPath() + ": " + fileIOError.getErrorCode());
        }
        return fileIOError;
    }

    @Override
    protected void onDestroy(@Nonnull IScope iScope) {
        for (TemporaryUserDataObject temporaryUserDataObject : this.m_aMap.values()) {
            UserUploadManager._deleteUDO(temporaryUserDataObject);
        }
        this.m_aMap.clear();
    }

    public void addUploadedFile(@Nonnull @Nonempty String string, @Nonnull TemporaryUserDataObject temporaryUserDataObject) {
        ValueEnforcer.notEmpty(string, "FieldName");
        ValueEnforcer.notNull(temporaryUserDataObject, "UDO");
        this.m_aRWLock.writeLocked(() -> {
            TemporaryUserDataObject temporaryUserDataObject2 = (TemporaryUserDataObject)this.m_aMap.remove(string);
            if (temporaryUserDataObject2 != null) {
                UserUploadManager._deleteUDO(temporaryUserDataObject2);
            }
            this.m_aMap.put(string, temporaryUserDataObject);
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, UserDataObject> confirmUploadedFiles(String ... stringArray) {
        CommonsLinkedHashMap<String, UserDataObject> commonsLinkedHashMap = new CommonsLinkedHashMap<String, UserDataObject>();
        if (stringArray != null) {
            this.m_aRWLock.writeLocked(() -> {
                for (String string : stringArray) {
                    TemporaryUserDataObject temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove(string);
                    if (temporaryUserDataObject == null) continue;
                    LOGGER.info("Confirmed uploaded file " + temporaryUserDataObject);
                    commonsLinkedHashMap.put(string, new UserDataObject(temporaryUserDataObject.getPath()));
                }
            });
        }
        return commonsLinkedHashMap;
    }

    @Nullable
    public UserDataObject confirmUploadedFile(@Nullable String string) {
        return this.m_aRWLock.writeLockedGet(() -> {
            TemporaryUserDataObject temporaryUserDataObject;
            if (StringHelper.hasText(string) && (temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove(string)) != null) {
                LOGGER.info("Confirmed uploaded file " + temporaryUserDataObject);
                return new UserDataObject(temporaryUserDataObject.getPath());
            }
            return null;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> cancelUploadedFiles(String ... stringArray) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        if (ArrayHelper.isNotEmpty(stringArray)) {
            this.m_aRWLock.writeLocked(() -> {
                for (String string : stringArray) {
                    TemporaryUserDataObject temporaryUserDataObject = (TemporaryUserDataObject)this.m_aMap.remove(string);
                    if (temporaryUserDataObject == null) continue;
                    UserUploadManager._deleteUDO(temporaryUserDataObject);
                    commonsArrayList.add(string);
                }
            });
        }
        return commonsArrayList;
    }

    @Nullable
    public TemporaryUserDataObject getUploadedFile(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (TemporaryUserDataObject)this.m_aMap.get(string));
    }

    @Nonnegative
    public int getUploadedFileCount() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("Map", this.m_aMap).getToString();
    }
}

