/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.userdata;

import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.photon.core.userdata.TemporaryUserDataObject;
import com.helger.photon.core.userdata.UserUploadManager;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUploadXServletHandler
implements IXServletSimpleHandler {
    public static final String PARAM_DIRECTORY = "dir";
    public static final String PARAM_ID = "id";
    public static final String PARAM_FILE = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserUploadXServletHandler.class);

    @Nonnull
    protected IJsonObject createSuccess() {
        return new JsonObject().add("success", true);
    }

    @Nonnull
    protected IJsonObject createError(@Nonnull String string) {
        LOGGER.error("User upload error: " + string);
        return new JsonObject().add("success", false).add("error", string).add("preventRetry", true);
    }

    private void _post(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        IJsonObject iJsonObject;
        Object VALUETYPE = iRequestWebScopeWithoutResponse.params().getValue(PARAM_FILE);
        if (!(VALUETYPE instanceof IFileItem)) {
            iJsonObject = this.createError("No file passed. Maybe the request is not multipart, put 'multipart/form-data' enctype for your form.");
        } else {
            IFileItem iFileItem = (IFileItem)VALUETYPE;
            String string = iRequestWebScopeWithoutResponse.params().getAsString(PARAM_DIRECTORY);
            boolean bl = StringHelper.hasText(string);
            if (bl && !FilenameHelper.isValidFilenameWithPaths(string)) {
                iJsonObject = this.createError("The passed directory name '" + string + "' is invalid!");
            } else {
                String string2 = iRequestWebScopeWithoutResponse.params().getAsString(PARAM_ID);
                if (StringHelper.hasNoText(string2)) {
                    iJsonObject = this.createError("No file ID passed!");
                } else {
                    LOGGER.info("Uploading " + iFileItem + " as " + string2 + " to " + string);
                    String string3 = bl ? FilenameHelper.ensurePathEndingWithSeparator(string) : "/";
                    string3 = string3 + GlobalIDFactory.getNewPersistentStringID();
                    String string4 = FilenameHelper.getExtension(iFileItem.getNameSecure());
                    if (StringHelper.hasText(string4)) {
                        string3 = string3 + "." + string4;
                    }
                    string3 = string3.toLowerCase(Locale.US);
                    TemporaryUserDataObject temporaryUserDataObject = new TemporaryUserDataObject(string3);
                    try {
                        if (iFileItem.write(temporaryUserDataObject.getAsFile()).isFailure()) {
                            iJsonObject = this.createError("Failed to store uploaded file " + iFileItem + " to " + temporaryUserDataObject);
                        } else {
                            UserUploadManager.getInstance().addUploadedFile(string2, temporaryUserDataObject);
                            iJsonObject = this.createSuccess();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Writing " + iFileItem + " to " + temporaryUserDataObject + " failed", exception);
                        iJsonObject = this.createError("Failed to store uploaded file " + iFileItem + " to " + temporaryUserDataObject);
                    }
                }
            }
        }
        unifiedResponse.setMimeType(CMimeType.APPLICATION_JSON).setContentAndCharset(iJsonObject.getAsJsonString(), StandardCharsets.UTF_8);
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws ServletException, IOException {
        unifiedResponse.disableCaching();
        this._post(iRequestWebScopeWithoutResponse, unifiedResponse);
    }
}

