/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.jetty;

import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InternalJettyStopMonitorThread
extends Thread {
    public static final int STOP_PORT = 8079;
    public static final String STOP_KEY = "secret";
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalJettyStopMonitorThread.class);
    private final int m_nPort;
    private final String m_sKey;
    private final ServerSocket m_aServerSocket;
    private final IThrowingRunnable<Exception> m_aAction;

    public InternalJettyStopMonitorThread(@Nonnegative int n, @Nonnull String string, @Nonnull IThrowingRunnable<Exception> iThrowingRunnable) throws IOException {
        this.m_nPort = n;
        this.m_sKey = string;
        this.setDaemon(true);
        this.setName("JettyStopMonitor");
        this.m_aServerSocket = new ServerSocket(this.m_nPort, 1, InetAddress.getByName(null));
        this.m_aServerSocket.setReuseAddress(true);
        this.m_aAction = iThrowingRunnable;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Throwable throwable;
            Socket socket;
            while (true) {
                block44: {
                    block43: {
                        Throwable throwable2;
                        LineNumberReader lineNumberReader;
                        block40: {
                            block41: {
                                block42: {
                                    block37: {
                                        block38: {
                                            block39: {
                                                socket = this.m_aServerSocket.accept();
                                                throwable = null;
                                                lineNumberReader = new LineNumberReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                                                throwable2 = null;
                                                String string = lineNumberReader.readLine();
                                                if (this.m_sKey.equals(string)) break block37;
                                                LOGGER.warn("Stop key mismatch. Got '" + string + "' but was expecting something else");
                                                if (lineNumberReader == null) break block38;
                                                if (throwable2 == null) break block39;
                                                try {
                                                    lineNumberReader.close();
                                                }
                                                catch (Throwable throwable3) {
                                                    throwable2.addSuppressed(throwable3);
                                                }
                                                break block38;
                                            }
                                            lineNumberReader.close();
                                        }
                                        if (socket == null) continue;
                                        if (throwable != null) {
                                            try {
                                                socket.close();
                                                continue;
                                            }
                                            catch (Throwable throwable4) {
                                                throwable.addSuppressed(throwable4);
                                                continue;
                                            }
                                        }
                                        socket.close();
                                        continue;
                                    }
                                    String string = lineNumberReader.readLine();
                                    if (!"stop".equals(string)) break block40;
                                    StreamHelper.close(socket);
                                    StreamHelper.close(this.m_aServerSocket);
                                    this.m_aAction.run();
                                    if (lineNumberReader == null) break block41;
                                    if (throwable2 == null) break block42;
                                    try {
                                        lineNumberReader.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    break block41;
                                }
                                lineNumberReader.close();
                            }
                            if (socket == null) return;
                            if (throwable != null) {
                                try {
                                    socket.close();
                                    return;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    return;
                                }
                            }
                            socket.close();
                            return;
                        }
                        if (lineNumberReader != null) {
                            if (throwable2 != null) {
                                try {
                                    lineNumberReader.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                break block43;
                            } else {
                                lineNumberReader.close();
                            }
                        }
                        break block43;
                        catch (Throwable throwable8) {
                            try {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                if (lineNumberReader == null) throw throwable9;
                                if (throwable2 == null) {
                                    lineNumberReader.close();
                                    throw throwable9;
                                }
                                try {
                                    lineNumberReader.close();
                                    throw throwable9;
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                    throw throwable9;
                                }
                            }
                        }
                    }
                    if (socket == null) continue;
                    if (throwable == null) break block44;
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                socket.close();
            }
            catch (Throwable throwable12) {
                try {
                    throwable = throwable12;
                    throw throwable12;
                }
                catch (Throwable throwable13) {
                    if (socket == null) throw throwable13;
                    if (throwable == null) {
                        socket.close();
                        throw throwable13;
                    }
                    try {
                        socket.close();
                        throw throwable13;
                    }
                    catch (Throwable throwable14) {
                        throwable.addSuppressed(throwable14);
                        throw throwable13;
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error reading from socket", exception);
            return;
        }
    }
}

