/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.login;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.StringHelper;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.security.login.LoggedInUserManager;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LoggedInUserStorage {
    public static final String BASE_DIRECTORY = "userdata/";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggedInUserStorage.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static String s_sBaseDirectory = "userdata/";

    private LoggedInUserStorage() {
    }

    @Nonnull
    public static String getBaseDirectory() {
        return s_aRWLock.readLockedGet(() -> s_sBaseDirectory);
    }

    public static void setBaseDirectory(@Nonnull String string) {
        ValueEnforcer.notNull(string, "BaseDirectory");
        s_aRWLock.writeLockedGet(() -> {
            s_sBaseDirectory = string;
            return s_sBaseDirectory;
        });
    }

    @Nonnull
    public static File getUserdataDirectory() {
        String string = LoggedInUserManager.getInstance().getCurrentUserID();
        return LoggedInUserStorage.getUserdataDirectory(string);
    }

    @Nonnull
    public static File getUserdataDirectory(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "UserID");
        String string2 = FilenameHelper.getAsSecureValidASCIIFilename(string);
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalStateException("Passed user ID '" + string + "' is an empty filename!");
        }
        if (!string2.equals(string)) {
            LOGGER.warn("User ID '" + string + "' was modified to '" + string2 + "' to be used as a file system name!");
        }
        File file = WebFileIO.getDataIO().getFile(LoggedInUserStorage.getBaseDirectory() + string2);
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        return file;
    }
}

