/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.login;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.user.IUser;
import com.helger.scope.ISessionScope;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LoginInfo
implements IHasID<String> {
    private final IUser m_aUser;
    private final ISessionScope m_aSessionScope;
    private final LocalDateTime m_aLoginDT;
    private LocalDateTime m_aLastAccessDT;
    private LocalDateTime m_aLogoutDT;
    private final StringMap m_aAttrs = new StringMap();

    public LoginInfo(@Nonnull IUser iUser, @Nonnull ISessionScope iSessionScope) {
        this.m_aUser = ValueEnforcer.notNull(iUser, "User");
        this.m_aSessionScope = ValueEnforcer.notNull(iSessionScope, "SessionScope");
        this.m_aLastAccessDT = this.m_aLoginDT = PDTFactory.getCurrentLocalDateTime();
    }

    @Nonnull
    public IUser getUser() {
        return this.m_aUser;
    }

    @Nonnull
    public ISessionScope getSessionScope() {
        return this.m_aSessionScope;
    }

    @Nonnull
    @Nonempty
    public String getUserID() {
        return (String)this.m_aUser.getID();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.getUserID();
    }

    @Nonnull
    public LocalDateTime getLoginDT() {
        return this.m_aLoginDT;
    }

    @Nonnull
    public LocalDateTime getLastAccessDT() {
        return this.m_aLastAccessDT;
    }

    public void setLastAccessDTNow() {
        this.m_aLastAccessDT = PDTFactory.getCurrentLocalDateTime();
    }

    @Nullable
    public LocalDateTime getLogoutDT() {
        return this.m_aLogoutDT;
    }

    public void setLogoutDTNow() {
        this.m_aLogoutDT = PDTFactory.getCurrentLocalDateTime();
    }

    public boolean isLogout() {
        return this.m_aLogoutDT != null;
    }

    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LoginInfo loginInfo = (LoginInfo)object;
        return this.m_aUser.equals(loginInfo.m_aUser) && this.m_aSessionScope.getID().equals(loginInfo.m_aSessionScope.getID()) && this.m_aLoginDT.equals(loginInfo.m_aLoginDT) && this.m_aLastAccessDT.equals(loginInfo.m_aLastAccessDT) && EqualsHelper.equals(this.m_aLogoutDT, loginInfo.m_aLogoutDT) && this.m_aAttrs.equals(loginInfo.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aUser).append(this.m_aSessionScope.getID()).append(this.m_aLoginDT).append(this.m_aLastAccessDT).append(this.m_aLogoutDT).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("User", this.m_aUser).append("SessionScopeID", this.m_aSessionScope.getID()).append("LoginDT", this.m_aLoginDT).append("LastAccessDT", this.m_aLastAccessDT).appendIfNotNull("LogoutDT", this.m_aLogoutDT).append("Attrs", this.m_aAttrs).getToString();
    }
}

